/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */
/* $Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $ */

/*srctext.ch: Text subclass specialized for dealing with source code text views. */

#include <ctype.h>

/* for keyword hash-table lookup */
#define TABLESIZE 53
#define HASH(word) ((*(word)+word[strlen(word)-1]*strlen(word))%TABLESIZE)

/* arbitrary number for how many Tab Stops can be set */
#define MAX_TABSTOPS 80

/* kinds of styles that are used in hash table (other style numbers are defined in subclasses) */
#define MAX_STYLES 16
#define UPRCSE 0            /* a null style array entry for uppercase words */
                            /* values from 1 to MAX_STYLES-2 can be used for subclass-specific styles */
#define USRDEF MAX_STYLES-1 /* user-defined keywords */

typedef struct DictStruct {
    char    *stng;
    short   val;    /*bits contain indentation info*/
    short   kind;    /*used for multiple style types*/
    struct DictStruct *next;
} Dict;

class srctext: text {

  overrides:
    Clear();
    GetModified() returns long;
    InsertCharacters(long pos, char *str, long len) returns boolean; /*RSK91overstrike*/
    Read(FILE *file, long id) returns long;
    SetAttributes(struct attributes *atts);
    Write(FILE *file, long writeID, int level) returns long;

  methods:
    /* Polymorphism Enablers */
    BackwardCheckWord(long pos,long first);
    CheckWord(long i,long end) returns long;
    InCommentStart(long pos) returns long;
    Indentation(long pos) returns int;
    IsTokenChar(char ch) returns boolean;
    Keywordify(char *buff, boolean checkforceupper) returns char *;
    RedoStyles();
    StyleComment(long start) returns long;

    /* Normal Methods */
    BackwardCopyWord(long from,long to,char buffer[]) returns long;
    BackwardSkipString(pos,delim) returns long;
    Breakable(pos) returns boolean;
    BreakLine(struct mark *endofline);
    CheckLineLengths(int maxlen,struct view *view);
    CopyWord(long pos,long end,char buffer[]) returns long;
    CurrentIndent(long pos) returns int;
    CurrentColumn(long pos) returns int;
    DoMatch(long pos,char *str,int len) returns boolean;
    FindDogtags();
    FindSrcInsets();
    GetEnvironment(long pos) returns struct environment *;
    GetStyle(long pos) returns struct style *;
    GetToken(long *pos, long *len);
    Indent(struct mark *range) returns long; /* override this if subclass does stuff to comments that are on lines with code (plxtext) */
    InsertNewStyle(long pos,long len,struct style *style, boolean begflag, boolean endflag);
    InString(pos) returns boolean;
    JustInsertCharacters(long pos,char *str,long len) returns boolean; /*RSK91overstrike*/
    LinesTooLong(int maxlen) returns boolean;
    NextTabStop(int curcol) returns int;
    OutputSrcInset(FILE *file,long writeID,struct dataobject *inset) returns boolean;
    OverstrikeAChar(long pos); /*RSK91overstrike*/
    Quoted(long pos) returns boolean; /* override this if subclass can have backslash-quoted characters (like \" in C) */
    ReflowComment(long pos) returns boolean; /* override this if subclass' comments are column-sensitive or something (plxtext) */
    ReindentLine(long pos); /* override this if subclass pads end-of-comments to right margin (plxtext) */
    RemoveStyles();
    ReverseBalance(long pos) returns long; /* override this if subclass can have nested comments (modtext) */
    SetSubclassName(char *scname);
    SetupStyles();
    SkipWhitespace(long pos,long end) returns long;
    StyleLinecomment(long start) returns long;
    TabAndOptimizeWS(long pos, int inc) returns long;
    TranslateSrcInset(long pos) returns long;
    WrapAStyle(long posn, long len, struct style *style);

  classprocedures:
    InitializeObject(struct srctext *self) returns boolean;
    FinalizeObject(struct srctext *self);
    BuildTable(char *classname,Dict *hashTable[],Dict wordlist[]);
    HashInsert(Dict *hashTable[], Dict *word);
    Lookup(Dict hashTable, char *word) returns Dict *;

  macromethods:
    GetForceUpper() ((self)->forceUpper)
    SetForceUpper( boolean newValue ) (((self)->forceUpper) = (newValue))
    GetSubclassName() ((self)->SubclassName)
    GetMaxLineLength() ((self)->maxlinelength)
    SetMaxLineLength(long newValue) (((self)->maxlinelength)= (newValue))
    IndentingEnabled() ((self)->indentingEnabled)
    IsInOverstrikeMode() ((self)->OverstrikeMode) /*RSK91overstrike*/
    ChangeOverstrikeMode(boolean newValue) (((self)->OverstrikeMode) = (newValue)) /*RSK91overstrike*/

  data:
    Dict **words;
    char *SubclassName;
    boolean forceUpper, useTabs, reindentComments, indentingEnabled;

    /* Generic styles. Specific styles go into kindStyle array. */
    struct style *comment_style, *cmmnt2NL_style, *function_style;
    struct style *kindStyle[MAX_STYLES];

    /* Variables used to control the indenting style. */
    int commentIndent, contIndent, levelIndent;
    int tabSize, numTabStops, tabStop[MAX_TABSTOPS];

    /* Variables used by Esc-1 and Esc-2 comment insertion */
    char *commentString, *linecommentString;
    int commentCol, linecommentCol;
    boolean commentFixed, linecommentFixed;

    /* "Temporary" stuff. maxlinelength stuff should go away as soon as programmers stop using punch cards (and fixed-length records) for their source code. RSK91overstrike stuff would be better implemented in ATK's text(VIEW) object. */
    long maxlinelength;
    boolean OverstrikeMode; /*RSK91overstrike*/ /*ideally, this should be associated with the view; unfortunately, the view is not known to srctext_InsertCharacters, which is where the overstriking is being done. But doing it in _InsertCharacters was a mistake *anyway*, so...*/
};

static boolean is_whitespace(ch)
char ch;
{ return (ch==' ')||(ch=='\t'); }

static char *makeupper(str)
char *str;
{
    char *st;
    st=str;
    while(*str!=0) {
	if(islower(*str)) *str=toupper(*str);
	str++;
    }
    return st;
}
