/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/


 



#define region_PROGRAMMERVERSION 2

class region {
methods:

    XorRegion(struct region * RHS, struct region * Result);
    UnionRegion(struct region * RHS, struct region * Result);
    IntersectRegion(struct region * RHS, struct region * Result);
    SubtractRegion(struct region * RHS, struct region * Result);
    ClearRegion();
    RectRegion(struct rectangle * NewRegnRect);
    DuplicateRegion() returns struct region *;
    OffsetRegion(long DeltaX, long DeltaY);
    InsetRegion(long DeltaX, long DeltaY);

    IsRegionEmpty() returns boolean;
    IsPointInRegion(struct point * TestPt) returns boolean;
    IsRectInRegion(struct rectangle * TestRect) returns boolean;
    AreRegionsEqual(struct region * TestRegion) returns boolean;

    GetBoundingBox(struct rectangle *rect) returns struct rectangle *;

macromethods:
    GetRegionData() ((self)->regionData)    /* Only used in the X code.  probably should subclass region to do this */

classprocedures:
    CreateEmptyRegion() returns struct region *;
    CreateRectRegion(struct rectangle * RegionShape) returns struct region *;
    CreateOvalRegion(struct rectangle * RegionShape) returns struct region *;
    CreatePolyRegion(struct point * PointArray, short PointCount) returns struct region *;
    CopyRegion(struct region * Destination, struct region * Source);
    FinalizeObject(struct region * self);
    InitializeObject(struct region *self) returns boolean;
data:
    struct _XRegion * regionData; /* really XRegion, but I don't want to include all of X just to get the typedef */
};

