/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/


 

/* The following may be use in place of a specific position  
	in the methods taking position arguments below  */
#define page_CURRENT		 -1
#define page_AFTERCURRENT	 -2
#define page_BEFORECURRENT	 -3
#define page_ATEND 		 -4
#define page_ATBEGINING	 -5

struct page_switchee {
    struct dataobject *d;
    char *viewname;
    char *label;
    struct page_switchee *next; 
};

class page : dataobject [dataobj] {
    classprocedures:
      InitializeObject(struct page *self) returns boolean;
      FinalizeObject(struct page *self);
    overrides:
      Read (FILE *file, long id) returns long;
      Write (FILE *file, long writeid, int level) returns long;
      ViewName() returns char *;
      GetModified() returns long;
    macromethods:
      GetPostMenus() ((self)->PostMenusFlag)
      SetPostMenus(foo) (((self)->PostMenusFlag) = foo)
      GetFirstObject() ((((self)->FirstSwitchee) == NULL) ? NULL: (self)->FirstSwitchee->d)
      GetNowPlaying() ((((self)->NowPlaying) == NULL) ? NULL: (self)->NowPlaying->d)

       /* The following macro methods are private */
      GetFirstSwitchee() ((self)->FirstSwitchee)
      GetNowPlayingSwitchee() ((self)->NowPlaying)
       
    methods:
      AddObject(struct dataobject *d, char *label,
		 char *viewname,long position) returns boolean;
      DeleteObject(struct dataobject *d) returns boolean;
      SetNowPlaying(struct dataobject *d) returns boolean;
      SetNowPlayingByName(char *name) returns boolean;
      GetNowPlayingName() returns char *;
      SetNowPlayingByPosition(long position) returns boolean;
      GetPositionOfObject(struct dataobject *d) returns long;
      GetNameOfObject(struct dataobject *d) returns char *;	
      GetObjectAtPosition(long position) returns struct dataobject *;
      GetObjectByName(char *name) returns struct dataobject *;
      GetObjectCount() returns long;
/* The following methods are private */
      GetSwitcheeName(struct page_switchee *sw) returns char *;
    data:
      struct page_switchee *FirstSwitchee, *NowPlaying;
      boolean PostMenusFlag,executingGetModified;
};
