/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/


 

/* init.H
 * Class header file for initialization file reader.
 *
 */

class init  {
    classprocedures:
        InitializeObject() returns boolean;
	FinalizeObject(struct init *self);
    methods:
        ModifyMenulist(struct menulist *ml) returns struct menulist *;
        ModifyKeystate(struct keystate *ks) returns struct keystate *;
        Duplicate() returns struct init *;
        Load(char *filename, procedure errorProc, long errorRock, boolean executeImmediately) returns int;
        AddKeyBinding(char *class, boolean inherit, struct keymap *keymap);
        DeleteKeyBinding(char *class, boolean inherit, struct keymap *keymap);
        AddMenuBinding(char *class, boolean inherit, struct menulist *menulist);
        DeleteMenuBinding(char *class, boolean inherit, struct menulist *menulist);

    data:
        struct keys *keys;
        struct menus *menus;
        struct keystateList *usedKeystates;
	struct mlList *usedMenus;
	struct children *kids;
	struct init *parent;
	int version;
};
