/* fontsel.ch - font selection inset dataobject */
/*
	Copyright Carnegie Mellon University 1992 - All rights reserved
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
  $Header: /usr/user/auis-7.2/overhead/c++conv/chfiles/RCS/fontsel.ch,v 1.1 1993/10/13 15:52:18 rr2b Exp $
*/

#define	fontsel_DATACHANGED	(1)

#define	fontsel_Style	(0)
#define	fontsel_Size	(1)
#define	fontsel_Family	(2)

#define	fontsel_default_Style	(0)
#define	fontsel_default_Size	(12)
#define	fontsel_default_Family	("andy")

class fontsel : dataobject [dataobj] {

    classprocedures:
      InitializeClass() returns boolean;
      InitializeObject(struct fontsel *self) returns boolean;
      FinalizeObject(struct fontsel *self);

    methods:
      SetStyle(long mask);
      SetSize(short val);
      SetFamily(char *val);

    macromethods:
      GetStyle()  ((self)->style)
      GetSize()  ((self)->size)
      GetFamily()  ((self)->family)
      IsActive(val)  ((self)->active & ((unsigned long)1<<(val)))
      UnsetStyle()  (fontsel_SetStyle((self), fontsel_default_Style), (self)->active &= ~((unsigned long)1<<fontsel_Style))
      UnsetSize()  (fontsel_SetSize((self), fontsel_default_Size), (self)->active &= ~((unsigned long)1<<fontsel_Size))
      UnsetFamily()  (fontsel_SetFamily((self), fontsel_default_Family), (self)->active &= ~((unsigned long)1<<fontsel_Family))

    data:
      long style;
      short size;
      char *family;

      long active;
};
