/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/msclients/nns/RCS/mcb.c,v 2.6 1992/12/15 21:22:34 rr2b R6tape $";
#endif

/* Methods for Message Cache Buckets
*/

/* BOGUS: include relevant AMS header(s) here */

#include <big.h>

void            MCBInit(mcb)
MCacheBucket_t *mcb;
{
    *mcb = NULL;
}

struct MS_Message *MCBFind(mcb, string)
MCacheBucket_t *mcb;
char           *string;
{
    MCacheBucketEntry_t *mcbe = *mcb;
    struct MS_Message *result = NULL;

    while (mcbe && !result) {
	if (strcmp(MCBEGetFilename(mcbe), string))
	    mcbe = MCBEGetNext(mcbe);
	else
	    result = MCBEGetMsg(mcbe);
    }
    return (result);
}

int             MCBMake(mcb, string, Msg)
MCacheBucket_t *mcb;
char           *string;
struct MS_Message *Msg;
{
    MCacheBucketEntry_t *tmp = (MCacheBucketEntry_t *) malloc(sizeof(MCacheBucketEntry_t));

    if (tmp) {
	MCBESet(tmp, string, Msg, *mcb);
	*mcb = tmp;
	return (TRUE);
    }
    return (FALSE);
}

void            MCBDelete(mcb, string)
MCacheBucket_t *mcb;
char           *string;
{
    MCacheBucketEntry_t *mcbe = *mcb, *prevmcbe = NULL;

    while (mcbe) {
	if (strcmp(MCBEGetFilename(mcbe), string)) {
	    prevmcbe = mcbe;
	    mcbe = MCBEGetNext(mcbe);
	}
	else {
	    if (prevmcbe)
		MCBESetNext(prevmcbe, MCBEGetNext(mcbe));
	    else
		*mcb = MCBEGetNext(mcbe);
	    free(mcbe);
	    mcbe = NULL;
	}
    }
}

void            MCBPurge(mcb)
MCacheBucket_t *mcb;
{
    MCacheBucketEntry_t *mcbe = *mcb, *next;

    while (mcbe) {
	next = MCBEGetNext(mcbe);
	free(mcbe);
	mcbe = next;
    }
    *mcb = NULL;
}
