/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/ms/RCS/errmsgs.c,v 2.8 1992/12/15 21:22:34 rr2b R6tape $";
#endif


 

#include <stdio.h>
#include <errprntf.h>
#include <mailconf.h>
#include <mail.h>
#include <util.h>
#include <ms.h>

/* The functions NonfatalBizarreError and CriticalBizarreError are in separate files to make it easier for clients to override them  */

extern char home[];
extern FILE *fopen();

static char *ErrLevel(level)
int level;
{
    switch(level) {
	case ERR_CRITICAL:
	    return("CRITICAL");
	case ERR_WARNING:
	    return("warning");
	default:
	    return("odd level");
    }
}

BizarreError(text, level)
char *text;
int level;
{
    static char ProgName[12] = "";
    char Fname[1+MAXPATHLEN];
    static int IsPostman = -1;
    FILE *fp = NULL;

    if (!ProgName[0]) {
	if (IsPostman < 0) {
	    struct CellAuth *ca; char *PMName;
	    ca = NULL;
	    FindAMSHomeCell(&ca);
	    PMName = NULL;
	    if (ca != NULL) {FillInCell(ca); PMName = CheckAMSPMName(ca->CellName);}
	    if (ca != NULL && ca->UserName != NULL && PMName != NULL && strcmp(ca->UserName, PMName) == 0) IsPostman = 1;
	    else IsPostman = 0;
	}
	if (IsPostman > 0) {
	    sprintf(ProgName, "ms-%d", getpid());
	} else {
	    strcpy(ProgName, "ms");
	}
    }
    if (AMS_DevConsoleIsSacred) {
	strcpy(Fname, home);
	strcat(home, "/MS-Errors"); /* This string also appears in ams/messages/msgsbe.c */
	fp = fopen(Fname, "a");
    }
    if (fp) {
	long foo;
	foo =time(0);
	fprintf(fp, "Message server %s message reported on %s: %s", ErrLevel(level), ctime(&foo), text);
	fclose(fp);
    } else {
	errprintf(ProgName, level, 0, 0, "%s", text);
    }
}

