/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/openpipe.c,v 2.10 1993/10/06 18:32:15 rr2b Exp $";
#endif

#include <stdio.h>
#include <andrewos.h>
#include <ms.h>
#include <mailconf.h>

extern char *getenv();
extern FILE *popen();

MS_OpenDebuggingPipescript(DoIt) 
int DoIt;  /* Turns it on or off */
{
    static FILE *ftmp = NULL;

    if (DoIt == 2) {
	char *TypescriptVector[2];
	char TypescriptCommand[100];

	sprintf(TypescriptCommand, AndrewDir("/bin/typescript"));
	TypescriptVector[0] = TypescriptCommand;
	TypescriptVector[1] = NULL;
	if (! osi_vfork()) {
	    int fd;

	    /* I am a child */
	    for (fd = FDTABLESIZE(); fd > 2; --fd) close(fd);
	    execv(TypescriptVector[0], TypescriptVector);
	    NonfatalBizarreError("Could not exec typescript");
	    _exit(1);
	}
	return(0);
    }
    if (DoIt) {
	char PipescriptCommand[100];
	sprintf(PipescriptCommand, AndrewDir("/bin/pipescript -t 'MessageServer Debugging'"));
	if (ftmp) pclose(ftmp);
	ftmp = popen(PipescriptCommand, "w");
	if (ftmp == NULL) {
	    AMS_RETURN_ERRCODE(errno, EIN_POPEN, EVIA_OPENDEBUGGINGPIPESCRIPT);
	}
	if (dup2(fileno(ftmp), 1) == -1) {
	    AMS_RETURN_ERRCODE(errno, EIN_DUP2, EVIA_OPENDEBUGGINGPIPESCRIPT);
	}
    } else {
	if (ftmp) {  /* No need to do it if ftmp is null */
	    pclose(ftmp);
	    dup2(1, 2);
	    ftmp = NULL;
	}
    }
    return(0);
}
