/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/getpathe.c,v 2.7 1992/12/15 21:19:11 rr2b R6tape $";
#endif

#include <ms.h>
#include <mailconf.h>

extern char home[];
extern Boolean DidInit;

MS_GetSearchPathEntry(which, buf, lim)
int     which,
        lim;
char   *buf;
{
    int     i;

    if (!DidInit) {		/* First time-only -- initialization
				   section */
	if ((i = InitializeSearchPaths()) != 0)
	    return(i);
    }
    switch(which) {
	case AMS_MAILPATH:
	    /* Wants *mail* directory */
	    strncpy(buf, home, lim);
	    strncat(buf, MAILSEARCHPATHTEMPLATE, lim);
	    break;
	case AMS_OFFICIALPATH:
	    strncpy(buf, OFFICIALSEARCHPATHTEMPLATE, lim);
	    break;
	case AMS_LOCALPATH:
	    strncpy(buf, LOCALSEARCHPATHTEMPLATE, lim);
	    break;
	case AMS_EXTERNALPATH:
	    strncpy(buf, EXTERNALSEARCHPATHTEMPLATE, lim);
	    break;
	default:
	    if (which < 0 || which >= MS_NumDirsInSearchPath) {
		AMS_RETURN_ERRCODE(EINVAL, EIN_PARAMCHECK, EVIA_GETSEARCHPATHENTRY);
	    }
	    if (strlen(SearchPathElements[which].Path) > lim) {
		AMS_RETURN_ERRCODE(ERANGE, EIN_PARAMCHECK, EVIA_GETSEARCHPATHENTRY);
	    }
	    strncpy(buf, SearchPathElements[which].Path, lim);
	    break;
    }
    return(0);
}
