

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
 * 
 * Permission to use, copy, modify, and distribute this software for any 
 * purpose is hereby granted, provided (a) that no fee is charged for the 
 * software, for the medium on which it is distributed, for the 
 * distribution process, or for effort involved in making the distribution;  
 * (b) that all copyright notices, this permission notice, and the 
 * following disclaimer remain in these files and appear in supporting 
 * documentation;  (c) that you do not translate, reverse engineer, 
 * decompile, or disassemble the software; and (d) that the names of 
 * IBM, Carnegie Mellon University, and other copyright holders not 
 * be used in advertising or publicity pertaining to distribution of the 
 * software.
 * 
 * CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
 * COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
 * WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
 * UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
 * OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/
#ifndef ANSITEXT_H
#define ANSITEXT_H

#define ansitext_BaseFactor		(2.0)
#define ansitext_AscenderFactor		(1.0)
#define ansitext_DescenderFactor	(1.0)

#define ansitext_CapitalFactor \
	(ansitext_BaseFactor + ansitext_AscenderFactor)
#define ansitext_DescentRatio \
	(ansitext_DescenderFactor / ansitext_CapitalFactor)

#define ansitext_ComputeAscent(fontsize)  (fontsize)
#define ansitext_ComputeDescent(fontsize) ((fontsize) * ansitext_DescentRatio)

#define ansitext_ComputeDelta(fontsize, spacing) \
	((((spacing) / 4.0) - (1.0 / 6.0)) * (fontsize))

#define ansitext_SlantFontSlope		(2.5)

#endif
