/* ********************************************************************** *\
 *	Copyright IBM Corporation 1988,1991 - All Rights Reserved 
 *	Copyright Carnegie Mellon University 1995 - All Rights Reserved
 *	For full copyright information see:'andrew/config/COPYRITE'
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
 * 
 * Permission to use, copy, modify, and distribute this software for any 
 * purpose is hereby granted, provided (a) that no fee is charged for the 
 * software, for the medium on which it is distributed, for the 
 * distribution process, or for effort involved in making the distribution;  
 * (b) that all copyright notices, this permission notice, and the 
 * following disclaimer remain in these files and appear in supporting 
 * documentation;  (c) that you do not translate, reverse engineer, 
 * decompile, or disassemble the software; and (d) that the names of 
 * IBM, Carnegie Mellon University, and other copyright holders not 
 * be used in advertising or publicity pertaining to distribution of the 
 * software.
 * 
 * CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
 * COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
 * WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
 * UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
 * OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /afs/cs/user/rr2b/7.4/src/RCS/nullvt.C,v 1.5 1995/01/27 02:29:26 wjh Stab74 $";
#endif


/* nullvt.c

	test the nullv object
*/

/*
 *    $Log: nullvt.C,v $
 * Revision 1.5  1995/01/27  02:29:26  wjh
 * update copyright
 * change variable frame to frm
 *
 * Revision 1.0  88/05/14  15:40:36  wjh
 * Copied from /usr/andrew/lib/genericinset
 */


#include <andrewos.h>
#include <stdio.h>

#include <null.H>
#include <nullview.H>

#include <im.H>
#include <view.H>
#include <frame.H>
#include <lpair.H>

/* required classes */
#include <environ.H>
#include <graphic.H>
#include <fontdesc.H>
#include <cursor.H>

/* classes that are anyway dynamically loaded by the
	required classes */
#include <dataobject.H>
#include <event.H>
#include <filetype.H>
#include <keymap.H>
#include <keystate.H>
#include <menulist.H>
#include <bind.H>
#include <proctable.H>
#include <message.H>
#include <msghandler.H>
#include <observable.H>
#include <updatelist.H>

extern void doStaticLoads();

/* LL - generate a horizontal or vertical pair of views 
	first arg is H or V to choose direction, second is percent of split,
	third and fourth args are the views 
	all boundaries are movable */

enum dir {H, V};

static class lpair * LL(enum dir  dir, short  pct, class lpair  *top , class lpair  *bot);
static void printdata(class dataobject *dobj);


static class lpair *
LL(enum dir  dir, short  pct, class lpair  *top , class lpair  *bot)
			{
	class lpair *ret = new lpair;
	if (dir == H) 
		(ret)->HSplit( top, bot, pct, TRUE);
	else
		(ret)->VSplit( top, bot, pct, TRUE);
	return ret;
}


void main(int argc, char **argv)
		{
	class null *dobj;
	class nullview *dview, *dview2;
	boolean debug = TRUE;

	class lpair *lpr;
	class frame *frm;
	FILE *f;
	char *fnm;
	class im *im;
	short i;
    
	printf("Start\n"); fflush(stdout);

	printf("Init done\n"); fflush(stdout);

/*	Cause static linking and loading of most ATK routines:
 */
	doStaticLoads(); /* found in statl.C generated by genstatl, see help genstatl. */
	im::SetProgramName("nullview test");

	fnm = NULL;
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-')
			switch (argv[i][1]) {
				case 'f': /* Debugging. */
					debug = FALSE;
					break;
				default: /* Unknown switch. Treat it as a file... */
					fnm = argv[i]+1;
					break;
			}
		else { /* Its a file right? */
			fnm = argv[i];
		}
	}

	dobj = new null;

	/* $$$ establish some initial contents for the data object */
	if (fnm && (f=fopen(fnm, "r")))
		(dobj)->Read( f, 0);
	else {
		(dobj)->AddDot( 10, 15);
	}

	printdata(dobj);
	dview = new nullview;
	(dview)->SetDataObject( dobj);

	if((im = im::Create(NULL)) == NULL) {	/* (argument can be hostname) */
	    fprintf(stderr,"Could not create new window.\nexiting.\n");
	    exit(-1);
	}
	if((frm = new frame) == NULL) {	/* use a frame to get message line */
	    fprintf(stderr,"Could not allocate enough memory.\nexiting.\n");
	    exit(-1);
	}
	(im)->SetView( frm);
	(frm)->PostDefaultHandler( "message", 
			(frm)->WantHandler( "message"));

	printf("Start building lpair\n"); fflush(stdout);

	/* build image */
	/*  This code makes two views of the data object.  
		$$$ You may want to have some other image */
	dview2 = new nullview;
	(dview2)->SetDataObject( dobj);
	lpr = LL(H, 40, (class lpair *)dview, (class lpair *)dview2);
	printf("Finish building lpair\n"); fflush(stdout);
	printdata(
		((class nullview *)(lpr)->GetNth( 1))->dataobject
	);

	/* in general, the application layer may have a surround (eg. scrollbar) 
			for nullview, GetApplicationLayer returns its argument */
	(frm)->SetView( (lpr)->GetApplicationLayer());

	/*  fork only if not debugging  
		(if it forks, the debugger cannot get at the core image)  */

	if (! debug) {
		int pid;
		if ((pid = fork()) < 0)   /* fork failed */
			exit(1);
      		else if (pid != 0)  /* exit from parent to release typescript */
			exit(0);
	}

	/* tell im to make the left view be the input focus */
	(dview)->WantInputFocus( dview);

	printf("Blastoff !!\n"); fflush(stdout);

	im::KeyboardProcessor();		/* Do it */
}

void printdata(class dataobject  *ndobj)
{
        class null *dobj=(class null *)ndobj;
	/* $$$ same procedure as in nulltest.c */
	struct dotlist *d;
	printf("null data object at 0x%lx\n", dobj);
	for (d = (dobj)->GetFirstDot();  d != NULL;  d = (dobj)->GetNextDot( d))
		printf("\t%d  \t%d\n", (dobj)->GetDotX( d), (dobj)->GetDotY( d));


	fflush(stdout);
}

