\begindata{text,135097344}
\textdsversion{12}
\template{default}
\define{footnote

attr:[Flags OverBar Int Set]
attr:[FontSize PreviousFontSize Point -2]}
\majorheading{Messages -  a Multi-Media Mailer

\smaller{\smaller{\smaller{
As published in the \italic{Linux Journal}, October, 1994}}}}


In this article, Terry Gliedt continues his tour through the Andrew project 
- this time into a new area, multi-media mail.


\heading{Introduction}


AUIS had its roots in 1982 when Carnegie Mellon University and the IBM 
Corporation decided to jointly develop a campus computing facility based on 
personal computers to replace the time-sharing system then on campus.  IBM 
provided not only generous funding, but also some talented individuals and 
access to IBM development programs.


The result was a graphical user interface we know as the Andrew User 
Interface System and a file system, the \italic{Andrew File System}.  The 
file system formed the basis of Transarc Corporation's \italic{Distributed 
File System} (DFS) and is as part of the Open System Foundation software.


The \italic{\bold{Andrew Consortium}}, composed of a number of corporations 
and universities, funds the current development of AUIS.  AUIS is available 
on a wide variety of platforms including Linux, AIX, Solaris, Ultrix, HP UX 
as well as others. \



In early June, version 6.3 of the Andrew User Interface System (AUIS) was 
released by the Andrew Consortium.  This led to the release of 
\bold{auis63L?-wp.tgz} which contains just a small portion of AUIS that is 
suitable as a word processor.


Now another package has been released, \bold{auis63L?-mail.tgz}, to 
\italic{sunsite.unc.edu} in \italic{/pub/Linux/X11/andrew}.  This package 
provides the Linux community a powerful mail system which leverages the 
power of the tools we see in the word processing package to provide 
multi-media mail. \



\heading{Multi-Media Mail}


Electronic mail is becoming enormously popular and common these days, but 
most of the tools we use have hardly changed since the earliest e-mail 
systems were invented.  A major effort in the Andrew project was the 
development of the Andrew Mail System (AMS) and its mail reading tool, 
\italic{messages}.  The developers at CMU wanted a mailer which not only 
met the needs of traditional mail systems, but could also be used for both 
public and private bulletin boards.  Today at CMU today one can follow over 
7500 bulletin boards with \italic{messages}. The scale of the data is a 
major factor in the design of \italic{messages}.


Another goal for the developers of \italic{messages} was to provide 
\underline{the} multi-media mail system.  The AUIS data-stream was designed 
from its inception to be mail-able.  This means it uses only 7-bit ASCII 
data which isn't "too long" for the various mail systems one might 
encounter. From a technical standpoint, this design has worked well.


\heading{MIME}


Early versions of \italic{messages} suffered from the chicken-and-egg 
syndrome.  Since there was no standard at the time, most people were 
reluctant to use \italic{messages} because not enough other people used it. 
 On the other hand, if a large number of people used it, then everyone 
would love to use messages.  For instance, if telephones were very uncommon 
and only 1% of people had one, your business would be unlikely to install a 
telephone.  On the other hand, no business today would think of not having 
a telephone, since virtually everyone has a telephone.


Everyone seemed to think \italic{messages} was great - but at the time you 
could only send AUIS-mail to others who used \italic{messages}.  On large 
homogenous sites like CMU, this worked fine.  But how to convince the rest 
of the world to convert?


After years of effort, the answer became obvious - you can't. Not everyone 
was going to convert to \italic{messages} - no matter how wonderful it 
might have been.  One of the principle architects of \italic{messages}, 
Nathaniel Borenstein, decided to take another tack.  He proposed an 
architecture called MIME (Multipurpose Internet Mail Extensions) that would 
allow one to send non-traditional mail (like pictures) in an architected 
format.  Nathaniel retrofitted \italic{messages} to send mail in MIME 
format instead of native Andrew Mail format.  When receiving MIME mail, he 
modified \italic{messages} to call a new program, \italic{metamail}, to 
display non-text on your machine. After demonstating that this all worked, 
Nathaniel provided similar updates to several common mailers to support 
MIME in the same manner.


For example, if I send mail using \italic{messages} with a picture to 
someone who uses some other mailer on a SUN workstation, the recipient's 
mailer might end up calling "xv" to display the picture.  In a non-X 
environment, perhaps some other tool might be called.  Finally, if the 
picture just cannot be displayed, then the mailer might "convert" the 
picture into some text like "a picture was provided here, but cannot be 
displayed".


\heading{Messages}


\italic{Messages} is actually just one part of a larger system known as the 
Andrew Mail System. This system supports reading and posting to bulletin 
boards and delivery between cells in the Andrew File System. I will not 
discuss any of these topics here, but rather just describe \italic{messages} 
as a conventional mail user agent.


To view your mail, invoke the command \italic{messages} from an 
\italic{xterm} window.  In Figure 1. you can see that the resulting 
\italic{messages} window has three parts.  The top window shows a list of 
folders where you can save mail.  The folder "mail" is where your incoming 
mail is saved until you move it elsewhere or delete it.  When you use 
\italic{messages} the first time, you will only have a mail folder. Begin 
by selecting a folder (probably \bold{mail}) by pointing to a name and 
clicking with the left mouse button.


\begindata{image,135097088}
format: gif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\enddata{image, 135097088}
\view{imagev,135097088,0,0,0}

The middle window will now display a summary of the mail in that folder. 
 Select one of these and you'll see the summary line in bold and in the 
bottom window, the text of the message. In Figure 1. you will notice 
several things.  The headers of the mail (From:, To:, etc.) are show in 
bold.  When you delete a piece of mail, the summary line is shown in a 
smaller font, but the actual file is not deleted until you explicitly 
delete it.  More discerning eyes will notice the scroll bar shows there is 
something above the \bold{From:} line.  This data is the normal mail 
headers which you normally do not want to see.  If you look at the headers 
for this particular piece of mail, you'd see that it has the lines:


\indent{\smaller{\bold{MIME-Version}: 1.0

}\smaller{\bold{Content-Type}: multipart/alternative; \


	boundary="Interpart.Boundary.ohyS2z9z0001I1RlEF"

}}
indicating this is MIME mail and consists of several parts.  If you look at 
the summary line for this mail, you'll notice the phrase "(60+1)", meaning 
the body consists of 60 characters and contains one inset.


In the body of the mail, you can see the phrase "Information SuperHighway" 
is in a larger bold font.  MIME's metamail or other low-end MIME reader 
would convert this to simple text on systems which do not have font 
capabilities.  On some systems the picture might show up in a separate 
window.  Since \italic{messages} has all the capabilities of AUIS, the text 
and images are shown in-line, as they were intended.


\heading{Sending Mail}


To compose and send mail to someone, select \italic{Send/Post Message} on 
the \italic{messages} menucard. This will present a window as shown in 
Figure 2.  In many ways, this is just another \italic{ez} session 
(\italic{ez} is the basic editor in AUIS and was described in more detail 
in previous issues of LJ).  In this particular example, I selected the mail 
we saw in Figure 1 and then I selected \italic{Reply to Sender} on the 
\italic{messages} menucard. This brought up the \italic{\bold{messages-send}} 
window with the \bold{Subject:} and \bold{To:} field already filled out.  I 
then selected the first sentence of the original mail (so it was shown in 
reverse video) and then in the \italic{\bold{messages-send}} window, 
selected \italic{Excerpt body} on the \italic{Other} menucard.  This 
resulted in the indented and italized \italic{Excerpts} lines that you see.


Had we not marked any text and simply selected this menu card, the entire 
original message body would have been copied, indented and italized.


\begindata{image,135096832}
format: gif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\enddata{image, 135096832}
\view{imagev,135096832,1,0,0}

Notice that the excerpted area may contain more than simple text, but also 
contains the large bolded \bold{Information SuperHighway}.  In fact we 
could have also included the image you saw in Figure 1.  To send the mail, 
select \italic{Send/Post} on the \italic{messages-send} menucard.  If the 
mail contains multi-media (anything except simple plain ASCII text), you 
will be prompted as shown in Figure 3.  If you select \italic{Remove 
formatting and send}, \italic{messages} will do some simple text 
conversion.  The excerpt will have the font information removed and the 
excerpt text itself will be prefixed with ">" as is common with many mail 
readers.  As you can see in Figure 3., you may choose to send the mail in 
the original AUIS format or in MIME format.  You can avoid the question 
altogether and always send in MIME format with an entry in your 
\italic{$HOME/preferences} file like this:


\indent{*.mailsendingformat: mime

}
Issue the command \bold{auishelp preferences} and read about the 
\bold{\italic{mailsendingformat}} setting.


\begindata{image,135096704}
format: gif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\enddata{image, 135096704}
\view{imagev,135096704,2,0,0}

\heading{Options}


Everyone wants to do mail their own way - and the same is true with 
\italic{messages}.  \italic{Messages} has dozens of options you may set - 
so many so, that it provides its own interface to setting and querying 
these.  If you select \italic{Set Options} on the \italic{Other} menucard, 
\italic{messages} will present a list of the options and their current 
setting. I'll bet as soon as you have \italic{messages} working, it won't 
be long before you will be poring through the options, trying them out.


\heading{Compatibility with Other Mail Readers}


The designers chose to not keep the \italic{messages} database compatible 
with that of other Unix mail readers like \italic{elm}.  In conventional 
Un*x mail user agent (e.g. \italic{mail}) when mail is received, it is 
first stored in /usr/spool/mail/$USER as a simple "flat" file.  All the 
mail is mashed together in one physical file.  It's up to the mail reader 
to sort these out. This works fine when the file is small, but when you 
have 100 pieces of multi-media mail, each 50K in size, it starts getting 
unwieldy and slow.


Now when you invoke your mail reader (e.g. \italic{elm}), the reader shows 
you what is in /usr/spool/mail/$USER.  When you save the mail to a folder, 
the mail is appended to some file in $HOME/Mail  (e.g. ~/Mail/tpg in my 
case). Just as with the mail in /usr/spool/mail, this is also a simple file 
containing many logical files (pieces of mail). It will suffer even more 
from performance problems as you keep more and more mail around.  Most mail 
readers allow you to create separate folders for categories of mail - but 
each still uses one monolithic file.


In the world where AUIS was developed, it is not unusual for one to have 
hundreds of pieces of mail (and large multi-media mail at that). So 
another, incompatible approach was taken.  \italic{Messages} keeps each 
individual piece of mail as a \underline{separate file} in a folder (i.e. 
directory) and builds an index so it can quickly show whats in the folder. 
Each of these folders is kept in the directory $HOME/.MESSAGES.


The drawback to this approach is that you cannot directly switch between 
\italic{elm}, for example, and \italic{messages}.  Any mail received by 
\italic{messages} is not available in your next \italic{elm} session. 
 Similarly, mail you received in the past with \italic{elm}, is not 
directly available in \italic{messages}.  However, that does not mean it 
cannot be done - but you must do it "manually".  I have developed some 
techiques to allow you to "convert" your \italic{elm} mail for use in 
\italic{messages} and vice versa.   I will not describe these in detail, 
but rather direct you to read about it in /usr/andrew/README.ez.mail which 
is created when you install the \italic{\bold{auis63L?-mail}} package. \



\heading{Printing and Previewing}


Just as AUIS prints other text documents, \italic{messages} will print your 
mail using PostScript.  In this version AUIS objects all generate 
\italic{troff} output - along with copious amounts of embedded PostScript. 
 The \italic{troff} is then processed to generate the necessary PostScript. 
 The default print command will invoke a shell, 
\italic{/usr/andrew/etc/atkprint}.  The default preview command calls the 
shell \italic{/usr/andrew/etc/atkpreview}.  Each of these shells will 
invoke the \italic{groff} formatter to generate the PostScript output.  In 
\italic{atkpreview} the \italic{groff} output is directed into 
\italic{ghostview}.


\heading{For More Information}


A mailing list is available at info-andrew@andrew.cmu.edu (mail to 
info-andrew-request@andrew.cmu.edu for subscriptions).  The newsgroup 
comp.soft-sys.andrew is dedicated to the discussion of AUIS.  A World Wide 
Web home page can be found at 
http://www.cs.cmu.edu:8001:/afs/cs.cmu.edu/project/atk-ftp/web/andrew-home.h\
tml.  A book, \italic{Multimedia Application Development with the Andrew 
Toolkit}, has been published by Prentice-Hall (ISBN 0-13-036633-1).  An 
excellent tutorial is available from the Consortium by sending mail to 
info-andrew-request@andrew.cmu.edu and asking about the manual, \italic{A 
User's Guide to AUIS}.


\heading{About the Author, Terry Gliedt}


\begindata{image,135096576}
format: gif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\enddata{image, 135096576}
\view{imagev,135096576,3,0,0}

After spending over twenty years with IBM, Terry left Big Blue last year. 
 Although he has worked with Un*x and AUIS for over six years, he is a 
relative new-comer to Linux.  Terry does contract programming, teaches 
classes in C/C++ and Unix and writes the occasional technical document. 
 You can reach him at \italic{Software Toolsmiths}, (507) 356-4710 or by 
e-mail at \bold{tpg@mr.net}.


\enddata{text,135097344}
