;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                 ;;;
;;;                     S c o o p s                                 ;;;
;;;                                                                 ;;;
;;;                                                                 ;;;
;;;		Rewritten 5/20/87 for cscheme			    ;;;
;;;		by Steve Sherin--U of P				    ;;;
;;;                   File : interf.scm                             ;;;
;;;                                                                 ;;;
;;;                 Amitabh Srivastava                              ;;;
;;;                                                                 ;;;
;;;    This file contains class definition and processing of        ;;;
;;;    define-class.                                                ;;;
;;;                                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(syntax-table-define system-global-syntax-table 'define-class (macro e
    (let ((name (car e)) (classvars '()) (instvars '()) (mixins '())
          (options '())(allvars '())(method-values '())(inits '()))
      (letrec
        ((chk-class-def
           (lambda (deflist)
	     (if deflist
		 (begin
		  (cond ((eq? (caar deflist) 'classvars)
			 (set! classvars (cdar deflist)))
			((eq? (caar deflist) 'instvars)
			 (set! instvars (cdar deflist)))
			((eq? (caar deflist) 'mixins)
			 (set! mixins (cdar deflist)))
			((eq? (caar deflist) 'options)
			 (set! options (cdar deflist)))
			(else (error-handler (caar deflist) 0 '())))
		  (chk-class-def (cdr deflist)))
		 (update-allvars))))

	 (update-allvars
	  (lambda ()
	    (set! allvars
		  (append (mapcar (lambda (a) (if (symbol? a) a (car a)))
				  classvars)
			  (mapcar (lambda (a) (if (symbol? a) a (car a)))
				  instvars)))))


         (chk-option
           (lambda (opt-list)
             (let loop ((opl opt-list)(meths '()))
               (if opl
		   (loop
		    (cdr opl)
		    (cond ((eq? (caar opl) 'gettable-variables)
			   (append (generate-get (cdar opl)) meths))
			  ((eq? (caar opl) 'settable-variables)
			   (append (generate-set (cdar opl)) meths))
			  ((eq? (caar opl) 'inittable-variables)
			   (set! inits (cdar opl)) meths)
			  (else (error-handler (car opl) 1 '()))))
		   meths))))

       (chk-cvs
         (lambda (list-var)
           (mapcar
             (lambda (a)
               (if (symbol? a)
		   (list a #!false)
                   a))
             list-var)))

       (chk-init
         (lambda (v-form)
           (if (memq (car v-form) inits)
	       `(,(car v-form)
	(let ((temp (memq ',(car v-form) %sc-init-vals)))
;was '%sc-init-vals
		(if temp (cadr temp)
				,(cadr v-form))))
	       v-form)))

       (chk-ivs
         (lambda (list-var)
           (mapcar
             (lambda (var)
               (chk-init
		  (cond ((symbol? var) (list var #!false))
                        ((not-active? (cadr var)) var)
                        (else (active-val (car var) (cadr var))))))
             list-var)))

       (not-active?
         (lambda (a)
	   (or (not (pair? a))
               (not (eq? (car a) 'active)))))

       (empty-slot?
         (lambda (form)
	  (cond
		((symbol? form) #f)
		((eq? form #f) #t)
		(else #f))))

       (active-val
         (lambda (var active-form)
           (let loop ((var var)(active-form active-form)
		      (getfns '())(setfns '%sc-val))
             (if (not-active? (cadr active-form))
		 (create-active
		  var
		  (if (empty-slot? (caddr active-form))
		      getfns
		      (cons (caddr active-form) getfns))
		  (list 'set! var
			(if (empty-slot? (cadddr active-form))
			    setfns
			    (list (cadddr active-form) setfns)))
		  (cadr active-form))
		 (loop
		  var
		  (cadr active-form)
		  (if (empty-slot? (caddr active-form))
		      getfns
		      (cons (caddr active-form) getfns))
		  (if (empty-slot? (cadddr active-form))
		      setfns
		      (list (cadddr active-form) setfns)))))))

       (create-active
         (lambda (var getfns setfns localstate)
	 (begin
          (set! method-values
           (cons `(CONS ',(concat "GET-" var)
		(list 'lambda '() ',(expand-getfns var getfns)))
		 (cons `(CONS ',(concat "SET-" var)
				(list 'lambda (list '%sc-val)
					',setfns))
		       method-values)))
          (list var localstate))))

       (expand-getfns
         (lambda (var getfns)
           (let loop ((var var)(gets getfns)(exp-form var))
             (if gets
		 (loop
		  var
		  (cdr gets)
		  (list (car gets) exp-form))
		 exp-form))))
       (concat
         (lambda (str sym)
           (string->symbol (string-append str (symbol->string sym)))))

       (generate-get
         (lambda (getlist)
           (mapcar
             (lambda (a)
	       `(CONS ',(concat "GET-" a)
			(list 'lambda '()
				',a)))
             getlist)))

       (generate-set
         (lambda (setlist)
           (mapcar
             (lambda (a)
	       `(CONS ',(concat "SET-" a)
			(list 'lambda (list '%sc-val)
			   (list 'set! ',a '%sc-val))))
             setlist)))

     )

(begin
	(chk-class-def (cdr e))      
        (set! method-values
              (chk-option
                  (mapcar (lambda (a) (if (symbol? a) (cons a allvars) a))
                          options)))
	(set! instvars (if instvars (chk-ivs instvars)))
; Evaluate here so that active-value functions are generated properly.
; --Steve Sherin
	(set! classvars (if classvars (chk-cvs classvars)))

	(eval
        `(DEFINE ,name
	         (%SC-MAKE-CLASS
		  ',name
		  ',classvars
		  ',instvars
                  ',mixins
		  ,(if method-values (cons 'list method-values))
		    ))
	user-initial-environment)
)))))
