;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                 ;;;
;;;                     S c o o p s                                 ;;;
;;;                                                                 ;;;
;;;                                                                 ;;;
;;;		Rewritten 5/20/87 for cscheme			    ;;;
;;;		by Steve Sherin--U of P				    ;;;
;;;                   File : instance.scm                           ;;;
;;;                                                                 ;;;
;;;                 Amitabh Srivastava                              ;;;
;;;                                                                 ;;;
;;;    This file contains compiling and making of an instance.      ;;;
;;;                                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(syntax-table-define system-global-syntax-table 'compile-class (macro e
	`(let* ((name ,(car e))
	       (class (%sc-name->class name)))
      (if (%sc-class-compiled class)
	  name
          (begin
	   (%inherit-method-vars class)
	   (eval (%make-template name class) (the-environment)))))))
;;;

(define (%sc-compile-class class)
  (begin
    (%inherit-method-vars class)
    (eval (%make-template (%sc-name class) class) 
		user-initial-environment)))
;;;

(syntax-table-define system-global-syntax-table 'make-instance (macro e
	(cons (list '%sc-inst-template (car e)) (cdr e))))
;;;

(define %uncompiled-make-instance
  (lambda (class)
    (lambda init-msg
      (%sc-compile-class class)
      (apply (%sc-inst-template class) init-msg))))
;;;

(define %make-template
  (lambda (name class)
    `(begin
;;; do some work to make compile-file work
       (%sc-set-allcvs ,name ',(%sc-allcvs class))
       (%sc-set-allivs ,name ',(%sc-allivs class))
       (%sc-set-method-structure ,name
            ',(%sc-method-structure class))
;;; prepare make-instance template
       (%sc-set-inst-template ,name
          ,(%make-inst-template (%sc-allcvs class)
                               (%sc-allivs class)
                               (%sc-method-structure class)
                               name class))
       (%sc-method-thrust ,name)
       (%sc-set-class-compiled ,name #!TRUE)
       (%sc-set-class-inherited ,name #!TRUE)
       (%sign-on ',name ,name)
       ',name)))
;;;

(define %make-inst-template
  (lambda (cvs ivs method-structure name class)
    (let ((methods '((%*methods*% '-)))
          (classvar (append cvs '((%*classvars*% '-))))
          (instvar  (append ivs '((%*instvars*% '-)))))
;;; dummy variables are added to methods, cvs, and ivs to prevent the
;;; compiler from folding them away.
         `(let ,classvar
           (%sc-set-class-env ,name (the-environment))
            (let ,methods
              (%sc-set-method-env ,name (the-environment))
	      (let ((%sc-class ,name))
              (lambda %sc-init-vals
                (let ,instvar
                  (the-environment)))))))))



;;; %sc-method-thrust evaluates each method in the method-environment
;;; for the class, enabling methods to grab free variables from the
;;; class-environment without a special code-replacement call.

(define (%sc-method-thrust class)
  (define (iter binding-pair)
    (let* ((method-name (car binding-pair))
	   (quoted-val (cdr binding-pair))
	   (temp `(in-package (%sc-method-env class)
			(define ,method-name ,quoted-val))))
      (eval temp (the-environment))))
(mapcar iter (%sc-method-values class)))



