/*
 * equiv-prim.c -- Implementation of Scheme's primitive equivalence predicates
 *
 * (C) m.b (Matthias Blume); May 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) equiv-prim.c (C) M.Blume, Princeton University, 2.2"
 */

# ident "@(#)equiv-prim.c	(C) M.Blume, Princeton University, 2.2"

# include "Cont.h"
# include "Boolean.h"
# include "storext.h"

# include "builtins.tab"

unsigned ScmPrimitiveEqvP (unsigned argcnt)
{
  void *tmp1, *tmp2;
  tmp1 = POP ();
  tmp2 = PEEK ();
  tmp1 = eqv_object (tmp1, tmp2) ? &ScmTrue : &ScmFalse;
  SET_TOP (tmp1);
  return 0;
}

unsigned ScmPrimitiveEqualP (unsigned argcnt)
{
  void *tmp1, *tmp2;
  tmp1 = POP ();
  tmp2 = PEEK ();
  tmp1 = equal_object (tmp1, tmp2) ? &ScmTrue : &ScmFalse;
  SET_TOP (tmp1);
  return 0;
}

unsigned ScmPrimitiveEqP (unsigned argcnt)
{
  void *tmp1, *tmp2;
  tmp1 = POP ();
  tmp2 = PEEK ();
  SET_TOP (tmp1 == tmp2 ? &ScmTrue : &ScmFalse);
  return 0;
}
