/*
 * Boolean.c -- Implementation of Scheme Booleans (and ())
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) Boolean.c (C) M.Blume, Princeton University, 2.3"
 */

# ident "@(#)Boolean.c	(C) M.Blume, Princeton University, 2.3"

# include <stdio.h>

# include "storext.h"
# include "Boolean.h"
# include "type.h"
# include "identifier.h"
# include "except.h"

static void dumper (void *vbool, FILE *file)
{
  putc (vbool == &ScmTrue
	  ? 't'
	  : vbool == &ScmFalse
	     ? 'f'
	     : vbool == &ScmEof
	       ? 'e'
	       : 'n',
	file);
}

static void *excavator (FILE *file)
{
  switch (getc (file)) {
  case 't':
    return &ScmTrue;
  case 'f':
    return &ScmFalse;
  case 'n':
    return &ScmNil;
  case 'e':
    return &ScmEof;
  default: /* including EOF */
    fatal ("bad dump file format (Boolean)");
    break;
  }
  /*NOTREACHED*/
}

static
void display (void *vbool, putc_proc pp, void *cd)
{
  if ((ScmBoolean *) vbool == &ScmNil)
    putc_string ("()", pp, cd);
  else if ((ScmBoolean *) vbool == &ScmEof)
    putc_string ("#<End-of-File>", pp, cd);
  else {
    (* pp) ('#', cd);
    (* pp) (((ScmBoolean *) vbool == &ScmTrue) ? 't' : 'f', cd);
  }
}

MEM_VECTOR (Boolean,
	    0, MEM_NULL_measure,
	    MEM_NULL_iterator, dumper, excavator, MEM_NULL_revisor,
	    MEM_NULL_task, MEM_NULL_task, MEM_NULL_task,
	    EXT (SCM_NO_NUMBER,
		 cannot_cvt_real, display, display, NULL_eq, NULL_eq));

ScmBoolean ScmTrue = {
  ScmType (Boolean)
};

ScmBoolean ScmFalse = {
  ScmType (Boolean)
};

ScmBoolean ScmNil = {
  ScmType (Boolean)
};

ScmBoolean ScmEof = {
  ScmType (Boolean)
};
