/*
 *
 *  p o r t . h			-- ports implementation
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *            Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 17-Feb-1993 12:27
 * Last file update: 28-Nov-1993 20:41
 *
 */

/* external vars */
extern SCM curr_iport, curr_oport, curr_eport, eof_object;


void freeport(SCM port);
void init_standard_ports(void);
SCM loadfile(char *fname, int err_if_absent);

PRIMITIVE input_portp(SCM port);
PRIMITIVE output_portp(SCM port);
PRIMITIVE current_input_port(void);
PRIMITIVE current_output_port(void);
PRIMITIVE current_error_port(void);
PRIMITIVE with_input_from_file(SCM string, SCM thunk);
PRIMITIVE with_output_to_file(SCM string, SCM thunk);
PRIMITIVE open_input_file(SCM filename);
PRIMITIVE open_output_file(SCM filename);
PRIMITIVE close_input_port(SCM port);
PRIMITIVE close_output_port(SCM port);
PRIMITIVE lread(SCM port);
PRIMITIVE read_char(SCM port);
PRIMITIVE peek_char(SCM port);
PRIMITIVE eof_objectp(SCM obj);
PRIMITIVE char_readyp(SCM port);
PRIMITIVE lwrite(SCM expr, SCM port);
PRIMITIVE display(SCM expr, SCM port);
PRIMITIVE newline(SCM port);
PRIMITIVE write_char(SCM c, SCM port);
PRIMITIVE scheme_load(SCM filename);

/* Non standard functions */
PRIMITIVE format(SCM l);
PRIMITIVE lerror(SCM l);
PRIMITIVE try_load(SCM filename);
PRIMITIVE open_file(SCM filename, SCM mode);
PRIMITIVE close_port(SCM port);
PRIMITIVE read_line(SCM port);
PRIMITIVE lflush(SCM port);



