/*
 *
 * b o o l e a n . c			-- Booleans and Equivalence predicates
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: 23-Oct-1993 21:37
 * Last file update: 11-Mar-1994 16:16
 */

#include "stk.h"

PRIMITIVE not(SCM x)
{
  return EQ(x, ntruth) ? truth : ntruth;
}

PRIMITIVE booleanp(SCM x)
{
  return BOOLEANP(x) ? truth: ntruth;
}

PRIMITIVE eqv(SCM x, SCM y)
{
  if EQ(x,y) return(truth);
  if (SYMBOLP(x) && SYMBOLP(y) && strcmp(PNAME(x), PNAME(y)) == 0)
    return truth;
  if (NUMBERP(x) && NUMBERP(y)) {
    if ((EXACTP(x) && FLONUMP(y)) || (FLONUMP(x) && EXACTP(y))) return ntruth;
    return (do_compare(x,  y) == 0) ? truth : ntruth;
  }
  if (CHARP(x) && CHARP(y) && CHAR(x) == CHAR(y))
    return truth;
  if (KEYWORDP(x)&&KEYWORDP(y)&&strcmp(KEYVAL(x), KEYVAL(y)) == 0)
    return truth;
  /* What can we do else? */
  return ntruth;
}

PRIMITIVE eq(SCM x,SCM y)
{
  return EQ(x,y) ? truth : ntruth;
}

PRIMITIVE equal(SCM x, SCM y)
{
Top:
  if (eqv(x, y) == truth) return truth;
  switch (TYPE(x)) {
    case tc_cons:   if (CONSP(y)) {
      		      if (equal(CAR(x), CAR(y)) == ntruth) return ntruth;
		      x = CDR(x); y = CDR(y);
		      goto Top;
		    }
		    break;
    case tc_string: if (STRINGP(y)) 
                      return (strcmp(CHARS(x), CHARS(y))==0) ? truth: ntruth;
                    break;
    case tc_vector: if (VECTORP(y)) 
                      return equal(vector2list(x), vector2list(y));
  }
  return ntruth;
}


