; Similix postprocessing
; Copyright (C) 1993 Anders Bondorf
; Please see the file README for copyright notice, license and disclaimer.


;-----------------------------------------------------------------------------
; Postunfolding residual procedure calls:

(define **Similix-postunfold** #t)
(define (postunfold-on) (set! **Similix-postunfold** #t))
(define (postunfold-off) (set! **Similix-postunfold** #f))

;-----------------------------------------------------------------------------
; Optimization of primitive operations:

(define **Similix-optimize-standard-primops** #t)

; When **Similix-optimize-sim-primops** and
; **Similix-optimize-standard-primops** are BOTH #t, the programs
; generated by self-application (or by applying the compiler generator)
; are optimized. The optimizations affect the Scheme top-level. Consider
; a program prog and the program mix-prog = cogen(prog) = mix(mix,prog).
; If (and only if) mix-prog is generated while the optimizations are
; enabled, loading mix-prog will also load the primitive operators
; loaded by prog. The optimized version of mix-prog thus needs to load
; more primitive operators at the top-level, but it is shorter in terms
; of code size and also faster.
(define **Similix-optimize-sim-primops** #t)

;-----------------------------------------------------------------------------
(define (_sim-postprocess! adt* res-def* goal residual-goal)
  (let ((name-clash-list (_sim-fully-lazy-assoc-udo-program-ncl adt*))
	(additional-adt* '())
	(arithmetic-operators
	 '(number? + * - / = < > <= >=
		   zero? positive? negative? odd? even?
		   max min abs quotient remainder modulo
		   number->string))
	(arithmetic-syn2sem
	 (lambda (op)
	   (case op
	     ((number?) number?)
	     ((+) +)
	     ((*) *)
	     ((-) -)
	     ((/) /)
	     ((=) =)
	     ((<) <)
	     ((>) >)
	     ((<=) <=)
	     ((>=) >=)
	     ((zero?) zero?)
	     ((positive?) positive?)
	     ((negative?) negative?)
	     ((odd?) odd?)
	     ((even?) even?)
	     ((max) max)
	     ((min) min)
	     ((abs) abs)
	     ((quotient) quotient)
	     ((remainder) remainder)
	     ((modulo) modulo)
	     ((number->string) number->string))))
	(standard-predicates
	 '(equal? boolean? not null? pair? list? symbol?
		  number? zero? positive? negative? odd? even?
		  char? char=? char<? char>? char<=? char>=?
		  char-ci=? char-ci<? char-ci>? char-ci<=? char-ci>=?
		  char-alphabetic? char-numeric? char-whitespace?
		  char-upper-case? char-lower-case?
		  string? string=? string-ci=?
		  string<? string>? string<=? string>=?
		  string-ci<? string-ci>? string-ci<=? string-ci>=?
		  vector? procedure?
		  input-port? output-port? eof-object?)))
    
    ;------------------------------------------------------------------------
    ; Generation of new variable names:
    (define **post-variable-generator** '(0))
    
    (define post-generate-name!
      (lambda (ide)
	(cons (car ide)
	      (_sim-next-number! **post-variable-generator**))))
    
    ;------------------------------------------------------------------------
    ; local definitions:
    
    
    (define (reduce-d d def*)
      (if (> **Similix-verbose-spec** 0)
	  (begin (display (_sim-residfetch-def-name d))
		 (display " ")
		 (_sim-flush-output-port)))

      (_sim-init-number-generator! **post-variable-generator**)
      (let* ((formal* (_sim-residfetch-def-pars d))
	     (new-formal* (map post-generate-name! formal*)))
	(_sim-build-resid-def
	 (_sim-residfetch-def-name d)
	 new-formal*
	 (reduce-e (_sim-residfetch-def-exp d)
		   def*
		   formal*
		   (map _sim-build-resid-var new-formal*)))))
    
    ; reduce-e uses the counter available in field 3 of each element
    ; of the global variable **Similix-seenb4** (i.e., the number of calls
    ; to the identified function); all corridor calls are eliminated
    ; (i.e. post unfolded). Beta reduction is performed.
    ;
    ; e == the residual expression to be reduced
    ; def* == the complete set of non-reduced definitions
    ; n* == name list
    ; v* == value list
    
    (define (reduce-e e def* n* v*)
      (let loop ((e e) (n* n*) (v* v*))
	(cond
	  ((_sim-isresidCst? e)
	   e)
	  ((_sim-isresidVar? e)
	   (lookup (_sim-residfetch-var-resid-name e) n* v*))
	  ((_sim-isresidCond? e)
	   (let* ((tes (loop (_sim-residfetch-cond-test e) n* v*))
		  (the (loop (_sim-residfetch-cond-then e) n* v*))
		  (els (loop (_sim-residfetch-cond-else e) n* v*)))
	     (local-reduce-cond tes the els)))
	  ((_sim-isresidLet? e)
	   (let* ((formal (_sim-residfetch-let-formal e))
		  (eod-actual (_sim-residfetch-let-eod-actual e))
		  (actual-reduced
		   (loop (_sim-residfetch-let-actual e) n* v*))
		  (body (_sim-residfetch-let-body e)))
	     (if (simple? actual-reduced)
		 (loop body (cons formal n*) (cons actual-reduced v*))
		 (let* ((new-formal (post-generate-name! formal))
			(body-reduced
			 (loop (_sim-residfetch-let-body e)
			       (cons formal n*)
			       (cons
				(_sim-build-resid-var new-formal)
				v*))))
		   (red-let
		    new-formal actual-reduced eod-actual body-reduced
		    (lambda ()
		      (local-reduce
		       (substitute body-reduced
				   (list new-formal)
				   (list actual-reduced))))
		    (lambda () (_sim-build-resid-begin
				actual-reduced body-reduced))
		    (lambda ()
		      (make-let new-formal
				eod-actual
				actual-reduced
				body-reduced)))))))
	  ((_sim-isresidBegin? e)
	   (local-reduce-begin
	    (loop (_sim-residfetch-begin-fst e) n* v*)
	    (loop (_sim-residfetch-begin-snd e) n* v*)))
	  ((_sim-isresidPrimop? e)
	   (local-reduce-primop (_sim-residfetch-primop-name e)
				(map (lambda (a) (loop a n* v*))
				     (_sim-residfetch-primop-args e))))
	  ((_sim-isresidCstr? e)
	   (_sim-build-resid-cstr
	    (_sim-residfetch-cstr-name e)
	    (map (lambda (a) (loop a n* v*)) (_sim-residfetch-cstr-args e))))
	  ((_sim-isresidSel? e)
	   (local-reduce-sel
	    (_sim-residfetch-sel-name e)
	    (_sim-residfetch-sel-proj e)
	    (_sim-residfetch-sel-cstr e)
	    (loop (_sim-residfetch-sel-arg e) n* v*)))
	  ((_sim-isresidPred? e)
	   (local-reduce-pred
	    (_sim-residfetch-pred-name e)
	    (_sim-residfetch-pred-cstr e)
	    (loop (_sim-residfetch-pred-arg e) n* v*)))
	  ((_sim-isresidPcall? e)
	   (let ((name (_sim-residfetch-pcall-name e))
		 (e* (_sim-residfetch-pcall-args e)))
	     (if (and **Similix-postunfold**
		      (= (list-ref (seenb4-assoc name **Similix-seenb4**) 3)
			 1))
		 ; call unfolding:
		 (let ((d (_sim-residfetch-udp-def-by-name name def*)))
		   (loop (_sim-residfetch-def-exp d)
			 (_sim-residfetch-def-pars d)
			 (map (lambda (a) (loop a n* v*)) e*)))
		 ; no call unfolding:
		 (_sim-build-resid-pcall
		  name (map (lambda (a) (loop a n* v*)) e*)))))
	  ((_sim-isresidAbs? e)
	   (let* ((formal* (_sim-residfetch-abs-formals e))
		  (new-formal* (map post-generate-name! formal*))
		  (body (_sim-residfetch-abs-body e)))
	     (_sim-build-resid-abs
	      new-formal*
	      (let loop1
		((e body)
		 (n* (append formal* n*))
		 (v* (let loop2 ((nf* new-formal*))
		       (if (null? nf*)
			   v*
			   (cons (_sim-build-resid-var (car nf*))
				 (loop2 (cdr nf*)))))))
		(if (possibly-inserted-let? e formal*)
		    ; don't postunfold (possibly) inserted lets:
		    (let* ((formal (_sim-residfetch-let-formal e))
			   (new-actual
			    (loop (_sim-residfetch-let-actual e)
				  n* v*))
			   ; create (let ((x x)) ...):
			   (new-formal
			    (_sim-residfetch-var-resid-name
			     new-actual)))
		      (make-let
		       new-formal
		       (_sim-residfetch-let-eod-actual e)
		       new-actual
		       (loop1 (_sim-residfetch-let-body e)
			      (cons formal n*)
			      (cons new-actual v*))))
		    ; no more inserted lets in the abstraction body
		    (loop e n* v*))))))
	  ((_sim-isresidApp? e)
	   (local-reduce-app
	    (loop (_sim-residfetch-app-exp e) n* v*)
	    (map (lambda (a) (loop a n* v*)) (_sim-residfetch-app-args e))))
	  (else
	   (_sim-error 'reduce-e "unknown residual syntactic form: ~s" e)))))
    
    ; -----------------------------------------------------------------------

    (define (red-let formal actual eod-actual body unf gen-begin gen)
      (if (simple? actual)
	  (unf)
	  (let ((count (oc-exact formal body)))
	    (cond
	      ((and (= count 1) 
		    (or (not (_sim-eod-imperative? eod-actual))
			(simple-body? body)))
	       (unf))
	      ((= count 0) (gen-begin))
	      (else (gen))))))
    
    ; simplify (let ((x exp)) x) to exp:
    (define (make-let new-formal eod-actual actual-reduced body-reduced)
      (if (and (_sim-isresidVar? body-reduced)
	       (equal? new-formal
		       (_sim-residfetch-var-resid-name body-reduced)))
	  actual-reduced
	  (_sim-build-resid-let
	   new-formal eod-actual actual-reduced body-reduced)))
    
    (define (simple? e)
      (or (_sim-isresidCst? e) (_sim-isresidVar? e)))
    
    (define (simple-body? e)
      (and (_sim-isresidPcall? e)
	   (_sim-andmap simple? (_sim-residfetch-pcall-args e))))
    
    (define (possibly-inserted-let? e formal*)
      (and (_sim-isresidLet? e)
	   (let ((actual (_sim-residfetch-let-actual e)))
	     (and (_sim-isresidVar? actual)
		  (member (_sim-residfetch-var-resid-name actual) formal*)))))
    
    
    ; -----------------------------------------------------------------------
    ; Local reductions (that require no environment)
    
    (define (local-reduce e)
      (cond
       ((_sim-isresidCst? e)
	e)
       ((_sim-isresidVar? e)
	e)
       ((_sim-isresidCond? e)
	(local-reduce-cond
	 (local-reduce (_sim-residfetch-cond-test e))
	 (local-reduce (_sim-residfetch-cond-then e))
	 (local-reduce (_sim-residfetch-cond-else e))))
       ((_sim-isresidLet? e)
	(let ((formal (_sim-residfetch-let-formal e))
	      (eod-actual (_sim-residfetch-let-eod-actual e))
	      (actual (local-reduce (_sim-residfetch-let-actual e)))
	      (body (local-reduce (_sim-residfetch-let-body e))))
	  (_sim-build-resid-let formal eod-actual actual body)))
       ((_sim-isresidBegin? e)
	(local-reduce-begin
	 (local-reduce (_sim-residfetch-begin-fst e))
	 (local-reduce (_sim-residfetch-begin-snd e))))
       ((_sim-isresidPrimop? e)
	(local-reduce-primop
	 (_sim-residfetch-primop-name e)
	 (map local-reduce (_sim-residfetch-primop-args e))))
       ((_sim-isresidCstr? e)
	(_sim-build-resid-cstr
	 (_sim-residfetch-cstr-name e)
	 (map local-reduce (_sim-residfetch-cstr-args e))))
       ((_sim-isresidSel? e)
	(local-reduce-sel
	 (_sim-residfetch-sel-name e)
	 (_sim-residfetch-sel-proj e)
	 (_sim-residfetch-sel-cstr e)
	 (local-reduce (_sim-residfetch-sel-arg e))))
       ((_sim-isresidPred? e)
	(local-reduce-pred
	 (_sim-residfetch-pred-name e)
	 (_sim-residfetch-pred-cstr e)
	 (local-reduce (_sim-residfetch-pred-arg e))))
       ((_sim-isresidPcall? e)
	(_sim-build-resid-pcall
	 (_sim-residfetch-pcall-name e)
	 (map local-reduce (_sim-residfetch-pcall-args e))))
       ((_sim-isresidAbs? e)
	(_sim-build-resid-abs
	 (_sim-residfetch-abs-formals e)
	 (local-reduce (_sim-residfetch-abs-body e))))
       ((_sim-isresidApp? e)
	(local-reduce-app
	 (local-reduce (_sim-residfetch-app-exp e))
	 (map local-reduce (_sim-residfetch-app-args e))))))
    
    
    (define (local-reduce-cond tes the els)
      (cond
       ((_sim-isresidCst? tes)
	; (if 'true' x y) --> x
	; (if #f x y) --> y
	(if (_sim-residfetch-cst-value tes)
	    the
	    els))
       ((and (_sim-isresidCst? the)
	     (_sim-isresidCst? els)
	     (boolean? (_sim-residfetch-cst-value the))
	     (boolean? (_sim-residfetch-cst-value els))
	     (_sim-residfetch-cst-value the)
	     (not (_sim-residfetch-cst-value els))
	     (or (and (_sim-isresidCst? tes)
		      (boolean? (_sim-residfetch-cst-value tes)))
		 (and **Similix-optimize-standard-primops**
		      (_sim-isresidPrimop? tes)
		      (member (_sim-residfetch-primop-name tes)
			      standard-predicates))))
	; (if x #t #f) --> x
	tes)
       (else
	(_sim-build-resid-cond tes the els))))
    
    (define (local-reduce-begin fst snd)
      (if (or (simple? fst) (_sim-isresidAbs? fst))
	  snd
	  (_sim-build-resid-begin fst snd)))


    (define (is-list? l-arg)
      (and (_sim-isresidPrimop? l-arg)
	   (equal? (_sim-residfetch-primop-name l-arg) 'list)))
    (define (is-nil? l-arg)
      (and (_sim-isresidCst? l-arg)
	   (null? (_sim-residfetch-cst-value l-arg))))
    (define (local-reduce-primop op arg*)
      (let ((default (lambda () (_sim-build-resid-primop op arg*))))
	(cond 
	  ((equal? op '_sim-memoize)
	   (car arg*))
	  (**Similix-optimize-standard-primops**
	   (cond
	     ((equal? op 'cons)
	      (let ((arg0 (car arg*))
		    (arg1 (cadr arg*)))
		(cond
		  ((and (_sim-isresidCst? arg1)
			(null? (_sim-residfetch-cst-value arg1)))
		   ; (cons x ()) --> (list x)
		   (_sim-build-resid-primop-l 'list arg0))
		  ((and (_sim-isresidPrimop? arg1)
			(equal? (_sim-residfetch-primop-name arg1) 'list))
		   ; (cons x (list y ...)) --> (list x y ...)
		   (_sim-build-resid-primop
		    'list
		    (cons arg0
			  (_sim-residfetch-primop-args arg1))))
		  (else
		   (default)))))
	     (else
	      (if **Similix-optimize-sim-primops**
		  (cond
		    ((pair? arg*)
		     (let ((arg0 (car arg*)))
		       (if (_sim-isresidCst? arg0)
			   (cond
			     ((equal? op '_sim-delta-reduce)
			      (let ((op1 (_sim-fetch-name-from-n+i
					  (_sim-residfetch-cst-value arg0)))
				    (l-arg (cadr arg*)))
				(cond
				  ((is-list? l-arg)
				   ; (_sim-delta-reduce
				   ;  '(primop index) (list e*))
				   ; --> (primop e*)
				   (_sim-build-resid-primop
				    op1 (_sim-residfetch-primop-args
					 l-arg)))
				  ((is-nil? l-arg)
				   ; (_sim-delta-reduce
				   ;  '(primop index) '()) --> (primop)
				   (_sim-build-resid-primop op1 '()))
				  (else
				   (default)))))
			     ((equal? op '_sim-build-primop)
			      (let ((op1 arg0)
				    (l-arg (cadr arg*)))
				(cond
				  ((is-list? l-arg)
				   ; (_sim-build-primop
				   ;  '(op index) (list arg*)) -->
				   ; (_sim-build-primop-l '(op index) arg*)
				   (_sim-build-resid-primop
				    '_sim-build-primop-l
				    (cons op1 (_sim-residfetch-primop-args
					       l-arg))))
				  ((is-nil? l-arg)
				   ; (_sim-build-primop '(op index) '()) -->
				   ; (_sim-build-primop-l '(op index))
				   (_sim-build-resid-primop-l
				    '_sim-build-primop-l op1))
				  (else
				   (default)))))
			     ((equal? op '_sim-cstr-reduce)
			      (let ((op1 (_sim-fetch-name-from-n+i
					  (_sim-residfetch-cst-value
					   (car arg*))))
				    (l-arg (cadr arg*)))
				(cond
				  ((is-list? l-arg)
				   ; (_sim-cstr-reduce
				   ;  '(cstr index) (list e*))
				   ; --> (cstr e*)
				   (_sim-build-resid-cstr
				    op1
				    (_sim-residfetch-primop-args l-arg)))
				  ((is-nil? l-arg)
				   ; (_sim-cstr-reduce '(cstr index) '())
				   ; --> (cstr)
				   (_sim-build-resid-cstr op1 '()))
				  (else
				   (default)))))
			     ((equal? op '_sim-sel-reduce)
			      ; (_sim-sel-reduce
			      ;  '(sel index proj cstr) e)
			      ;  --> (sel proj cstr e)
			      (let ((n+i+p+c
				     (_sim-residfetch-cst-value (car arg*))))
				(_sim-build-resid-sel
				 (_sim-fetch-name-from-n+i n+i+p+c)
				 (_sim-fetch-sel-proj-from-n+i n+i+p+c)
				 (_sim-fetch-sel-cstr-from-n+i n+i+p+c)
				 (cadr arg*))))
			     ((equal? op '_sim-pred-reduce)
			      ; (_sim-pred-reduce
			      ;  '(pred index cstr) e) --> (pred cstr e)
			      (let ((n+i+c
				     (_sim-residfetch-cst-value (car arg*))))
				(_sim-build-resid-pred
				 (_sim-fetch-name-from-n+i n+i+c)
				 (_sim-fetch-pred-cstr-from-n+i n+i+c)
				 (cadr arg*))))
			     ((equal? op '_sim-initialize-magic!)
			      (set! additional-adt*
				    (let loop
					((n (_sim-residfetch-cst-value
					     (car arg*)))
					 (a '()))
				      (if (null? n)
					  a
					  (let ((hd (car n))
						(rest (loop (cdr n) a)))
					    (if (member hd adt*)
						rest
						(cons hd rest))))))
			      (default))
			     (else
			      (default)))
			   (default))))
		    (else (default)))
		  (default)))))
	  (else
	   (default)))))

    (define (local-reduce-sel name proj cstr e)
      (if (and (_sim-isresidCstr? e)
	       (equal? cstr (_sim-residfetch-cstr-name e)))
	  ; (C-0 (C E0)) --> E0
	  ; (C-M (C E0 ... EM ...)) --> (begin E0 (begin ... ... EM))
	  (let ((e+ (_sim-residfetch-cstr-args e)))
	    (let loop ((e (car e+)) (e* (cdr e+)) (i 0))
	      (if (= i proj)
		  (let loop ((e* e*))
		    (if (null? e*)
			e
			(local-reduce-begin (car e*) (loop (cdr e*)))))
		  (local-reduce-begin
		   e (loop (car e*) (cdr e*) (+ 1 i))))))
	  (_sim-build-resid-sel name proj cstr e)))
    
    (define (local-reduce-pred name cstr e)
      (if (_sim-isresidCstr? e)
	  ; (C? (C  E0 ... EN)) --> (begin E0 (begin ... (begin EN #t)))
	  ; (C? (C' E0 ... EN)) --> (begin E0 (begin ... (begin EN #f)))
	  (let ((e* (_sim-residfetch-cstr-args e)))
	    (let loop ((e* e*))
	      (if (null? e*)
		  (_sim-build-resid-cst
		   (equal? cstr (_sim-residfetch-cstr-name e)))
		  (local-reduce-begin (car e*) (loop (cdr e*))))))
	  (_sim-build-resid-pred name cstr e)))

    (define (local-reduce-app e e*)
      (if (_sim-isresidAbs? e)
	  (beta-reduce e e*)
	  (_sim-build-resid-app e e*)))
    
    ; beta-reduce performs simple beta-reductions;
    ; further beta-reduction is not performed on the beta-reduced form,
    ; so the beta-reduction always terminates.
    (define (beta-reduce e e*)
      ; e is an abstraction
      (let ((formal* (_sim-residfetch-abs-formals e)))
	(let loop
	    ((e1 (_sim-residfetch-abs-body e))
	     (n* formal*)
	     (v* e*))
	  (if (possibly-inserted-let? e1 formal*)
	      (let ((formal (_sim-residfetch-let-formal e1))
		    (eod-actual (_sim-residfetch-let-eod-actual e1))
		    (actual
		     (lookup (_sim-residfetch-var-resid-name
			      (_sim-residfetch-let-actual e1))
			     n* v*))
		    (body (_sim-residfetch-let-body e1)))
		(red-let
		 formal actual eod-actual body
		 (lambda () (loop body (cons formal n*) (cons actual v*)))
		 (lambda () (_sim-build-resid-begin actual (loop body n* v*)))
		 (lambda () (make-let
			     formal eod-actual actual
			     (loop body
				   (cons formal n*)
				   (cons (_sim-build-resid-var formal)
					 v*))))))
	      ; no more inserted lets in the abstraction body:
	      (substitute e1 n* v*)))))

    ; -----------------------------------------------------------------------
    
    (define (substitute e n* v*)
      (let loop
	  ((e e))
	(cond
	  ((_sim-isresidCst? e)
	   e)
	  ((_sim-isresidVar? e)
	   (let ((resid-name (_sim-residfetch-var-resid-name e)))
	     (if (member resid-name n*) (lookup resid-name n* v*) e)))
	  ((_sim-isresidCond? e)
	   (_sim-build-resid-cond
	    (loop (_sim-residfetch-cond-test e))
	    (loop (_sim-residfetch-cond-then e))
	    (loop (_sim-residfetch-cond-else e))))
	  ((_sim-isresidLet? e)
	   (_sim-build-resid-let
	    (_sim-residfetch-let-formal e)
	    (_sim-residfetch-let-eod-actual e)
	    (loop (_sim-residfetch-let-actual e))
	    (loop (_sim-residfetch-let-body e))))
	  ((_sim-isresidBegin? e)
	   (_sim-build-resid-begin
	    (loop (_sim-residfetch-begin-fst e))
	    (loop (_sim-residfetch-begin-snd e))))
	  ((_sim-isresidPrimop? e)
	   (_sim-build-resid-primop
	    (_sim-residfetch-primop-name e)
	    (map loop (_sim-residfetch-primop-args e))))
	  ((_sim-isresidCstr? e)
	   (_sim-build-resid-cstr
	    (_sim-residfetch-cstr-name e)
	    (map loop (_sim-residfetch-cstr-args e))))
	  ((_sim-isresidSel? e)
	   (_sim-build-resid-sel
	    (_sim-residfetch-sel-name e)
	    (_sim-residfetch-sel-proj e)
	    (_sim-residfetch-sel-cstr e)
	    (loop (_sim-residfetch-sel-arg e))))
	  ((_sim-isresidPred? e)
	   (_sim-build-resid-pred
	    (_sim-residfetch-pred-name e)
	    (_sim-residfetch-pred-cstr e)
	    (loop (_sim-residfetch-pred-arg e))))
	  ((_sim-isresidPcall? e)
	   (_sim-build-resid-pcall
	    (_sim-residfetch-pcall-name e)
	    (map loop (_sim-residfetch-pcall-args e))))
	  ((_sim-isresidAbs? e)
	   (_sim-build-resid-abs
	    (_sim-residfetch-abs-formals e)
	    (loop (_sim-residfetch-abs-body e))))
	  ((_sim-isresidApp? e)
	   (_sim-build-resid-app
	    (loop (_sim-residfetch-app-exp e))
	    (map loop (_sim-residfetch-app-args e)))))))
    
    ; -----------------------------------------------------------------------
    
    ; Exact occurrence counting.
    ; 
    ;            any
    ;            / \
    ;           1   0
    ;            \ /
    ;           bottom (never used in practice)
    ;
    ; any is represented by any number greater than or equal to 2
    ;
    (define (my+ . args) (apply + args))
    (define (map-my+ f l)
      (if (null? l)
	  0
	  (my+ (f (car l)) (map-my+ f (cdr l)))))
    (define (lub c1 c2) (if (= c1 c2) c1 2))
    (define (oc-exact formal body)
      (let count ((e body))
	(cond
	  ((_sim-isresidCst? e)
	   0)
	  ((_sim-isresidVar? e)
	   (if (equal? (_sim-residfetch-var-resid-name e) formal) 1 0))
	  ((_sim-isresidCond? e)
	   (let ((then-part
		  (count (_sim-residfetch-cond-then e)))
		 (else-part
		  (count (_sim-residfetch-cond-else e))))
	     (my+ (count (_sim-residfetch-cond-test e))
		  (lub (my+ then-part else-part)
		       (lub then-part else-part)))))
	  ((_sim-isresidLet? e)
	   (my+ (count (_sim-residfetch-let-actual e))
		(count (_sim-residfetch-let-body e))))
	  ((_sim-isresidBegin? e)
	   (my+ (count (_sim-residfetch-begin-fst e))
		(count (_sim-residfetch-begin-snd e))))
	  ((_sim-isresidPrimop? e)
	   (map-my+ count (_sim-residfetch-primop-args e)))
	  ((_sim-isresidCstr? e)
	   (map-my+ count (_sim-residfetch-cstr-args e)))
	  ((_sim-isresidSel? e)
	   (count (_sim-residfetch-sel-arg e)))
	  ((_sim-isresidPred? e)
	   (count (_sim-residfetch-pred-arg e)))
	  ((_sim-isresidPcall? e)
	   (map-my+ count (_sim-residfetch-pcall-args e)))
	  ((_sim-isresidAbs? e)
	   (if (= (count (_sim-residfetch-abs-body e)) 0) 0 2))
	  ((_sim-isresidApp? e)
	   (my+ (count (_sim-residfetch-app-exp e))
		(map-my+ count (_sim-residfetch-app-args e)))))))
    
    ; -----------------------------------------------------------------------
    
    (define (seenb4-assoc x sb4)
      (if (null? sb4)
	  (_sim-error 'seenb4-assoc "~s is not in **Similix-seenb4** - ?" x)
	  (if (equal? x (list-ref (car sb4) 2))
	      (car sb4)
	      (seenb4-assoc x (cdr sb4)))))
    
    (define (lookup n n* v*)
      (let loop ((n* n*) (v* v*))
	(if (null? n*)
	    (_sim-error 'lookup "name not found: ~s" n)
	    (if (null? v*)
		(_sim-error 'lookup
			    "value list too short - n and n*: ~s and ~s"
			    n n*)
		(if (equal? n (car n*))
		    (car v*)
		    (loop (cdr n*) (cdr v*)))))))
    
    ;------------------------------------------------------------------------
    ; Converting from residual abstract to residual concrete syntax
    ; and redoing some local optizations:
    
    (define (abs->conc-d d)
      (let* ((n* (_sim-residfetch-def-pars d))
	     (formal* (map abs->conc-var n*))
	     (header (cons (_sim-residfetch-def-name d) formal*))
	     (body (abs->conc-e (_sim-residfetch-def-exp d) n* formal*)))
	(if (and (pair? body) (equal? (car body) 'begin))
	    (cons 'define (cons header (cdr body)))
	    (list 'define header body))))
    
    (define (abs->conc-e e n* v*)
      (cond
	((_sim-isresidCst? e)
	 (let ((v (_sim-residfetch-cst-value e)))
	   (if (or (boolean? v) (number? v) (string? v) (char? v))
	       v
	       (list 'quote v))))
	((_sim-isresidVar? e)
	 (lookup (_sim-residfetch-var-resid-name e) n* v*))
	((_sim-isresidCond? e)
	 (let ((tes (abs->conc-e (_sim-residfetch-cond-test e) n* v*))
	       (the (abs->conc-e (_sim-residfetch-cond-then e) n* v*))
	       (els (abs->conc-e (_sim-residfetch-cond-else e) n* v*)))
	   (cond
	     ; (if x x #f) --> x
	     ; (if x y #f) --> (and x y):
	     ((and (boolean? els) (not els))
	      (if (equal? tes the)
		  tes
		  (build-and tes the)))
	     ; (if x #f y) --> (and (not x) y):
	     ((and **Similix-optimize-standard-primops**
		   (boolean? the) (not the))
	      (build-and (list 'not tes) els))
	     ; (if x x x) --> x
	     ; (if x x y) --> (or x y):
	     ((and (symbol? tes) (symbol? the) (equal? tes the))
	      (if (equal? tes els)
		  tes
		  (list 'or tes els)))
	     ((and (pair? els) (member (car els) '(if cond and or)))
	      (let ((op (car els))
		    (tes-the (strip-begin tes the)))
		(cond
		  ((equal? op 'cond)
		   (cons 'cond (cons tes-the (cdr els))))
		  ((equal? op 'if)
		   (list 'cond
			 tes-the
			 (strip-begin (list-ref els 1) (list-ref els 2))
			 (strip-begin 'else (list-ref els 3))))
		  ((and (equal? op 'and) (= (length els) 3))
		   (list 'cond
			 tes-the
			 (strip-begin (list-ref els 1) (list-ref els 2))
			 (list 'else #f)  ; necessary to follow Scheme standard
			 ))
		  ((and (equal? op 'or) (= (length els) 3))
		   (list 'cond
			 tes-the
			 (list (list-ref els 1))
			 (strip-begin 'else (list-ref els 2))))
		  (else
		   (list 'if tes the els)))))
	     (else
	      (list 'if tes the els)))))
	((_sim-isresidLet? e)
	 (let ((e (remove-remaining-inserted-lets e)))
	   (if (_sim-isresidLet? e)
	       (let* ((n (_sim-residfetch-let-formal e))
		      (formal (abs->conc-var n))
		      (actual (abs->conc-e
			       (_sim-residfetch-let-actual e) n* v*))
		      (body (abs->conc-e (_sim-residfetch-let-body e)
					 (cons n n*)
					 (cons formal v*)))
		      (binding (list formal actual)))
		 (cond
		   ((and (pair? body) (member (car body) '(let let*)))
		    (cons 'let* (cons (cons binding (cadr body))
				      (cddr body))))
		   ((and (pair? body) (equal? (car body) 'begin))
		    (cons 'let (cons (list binding) (cdr body))))
		   (else
		    (list 'let (list binding) body))))
	       (abs->conc-e e n* v*))))
	((_sim-isresidBegin? e)
	 (build-begin (abs->conc-e (_sim-residfetch-begin-fst e) n* v*)
		      (abs->conc-e (_sim-residfetch-begin-snd e) n* v*)))
	((_sim-isresidPrimop? e)
	 (let ((op (_sim-residfetch-primop-name e))
	       (args (map (lambda (a) (abs->conc-e a n* v*))
			  (_sim-residfetch-primop-args e))))
	   ; last minute reductions performed here
	   (cond
	     ; arithmetic reductions (currently the only reduction performed):
	     ((and (member op arithmetic-operators) (_sim-andmap number? args))
	      (apply (arithmetic-syn2sem op) args))
	     (else (cons op args)))))
	((_sim-isresidCstr? e)
	 (cons (_sim-residfetch-cstr-name e)
	       (map (lambda (a) (abs->conc-e a n* v*))
		    (_sim-residfetch-cstr-args e))))
	((_sim-isresidSel? e)
	 (list (_sim-residfetch-sel-name e)
	       (abs->conc-e (_sim-residfetch-sel-arg e) n* v*)))
	((_sim-isresidPred? e)
	 (list (_sim-residfetch-pred-name e)
	       (abs->conc-e (_sim-residfetch-pred-arg e) n* v*)))
	((_sim-isresidPcall? e)
	 (cons (_sim-residfetch-pcall-name e)
	       (map (lambda (a) (abs->conc-e a n* v*))
		    (_sim-residfetch-pcall-args e))))
	((_sim-isresidAbs? e)
	 (let* ((n*1 (_sim-residfetch-abs-formals e))
		(old-body (remove-remaining-inserted-lets
			   (_sim-residfetch-abs-body e)))
		(formal* (map abs->conc-var n*1))
		(body (abs->conc-e old-body
				   (append n*1 n*)
				   (append formal* v*))))
	   (cond
	     ((and (pair? body) (equal? (car body) 'begin))
	      (cons 'lambda (cons formal* (cdr body))))
	     ; eta-reduction:
	     ; (lambda (x ...) (a x ...)) --> a
	     ((and (or (_sim-isresidPrimop? old-body)
		       (_sim-isresidCstr? old-body)
		       (_sim-isresidSel? old-body)
		       (_sim-isresidPred? old-body)
		       (_sim-isresidPcall? old-body))
		   (equal? formal* (cdr body)))
	      (car body))
	     (else
	      (list 'lambda formal* body)))))
	((_sim-isresidApp? e)
	 (cons (abs->conc-e (_sim-residfetch-app-exp e) n* v*)
	       (map (lambda (a) (abs->conc-e a n* v*))
		    (_sim-residfetch-app-args e))))))
    
    (define (abs->conc-var resid-name)
      (let loop ((s ""))
	(let ((rn (_sim-sym/num/string-append
		   (car resid-name) "_" s (cdr resid-name))))
	  (if (member rn name-clash-list)
	      (loop (string-append "_" s))
	      rn))))
    
    (define (remove-remaining-inserted-lets e)
      (if (_sim-isresidLet? e)
	  (let ((actual (_sim-residfetch-let-actual e)))
	    (if (and (_sim-isresidVar? actual)
		     (equal? (_sim-residfetch-var-resid-name actual)
			     (_sim-residfetch-let-formal e)))
		(remove-remaining-inserted-lets (_sim-residfetch-let-body e))
		e))
	  e))

    ; -----------------------------------------------------------------------

    (define (strip-begin tes the)
      (if (and (pair? the) (equal? (car the) 'begin))
	  (cons tes (cdr the))
	  (list tes the)))
    
    (define (build-and first second) (flatten first second 'and))
    (define (build-begin first second) (flatten first second 'begin))
    
    (define (flatten first second op)
      (let ((tf (and (pair? first) (equal? (car first) op)))
	    (ts (and (pair? second) (equal? (car second) op))))
	(cons op
	      (cond
		((and tf ts)
		 (_sim-append! (cdr first) (cdr second)))
		(tf
		 (_sim-append! (cdr first) (list second)))
		(ts
		 (cons first (cdr second)))
		(else
		 (list first second))))))
          
    ;------------------------------------------------------------------------

    (define (make-residual-goal-name goal residual-goal)
      (if (equal? residual-goal '())
	  (_sim-sym/num/string-append goal '- 0)
	  residual-goal))
    
    ;------------------------------------------------------------------------
    
    (define (remove-scheme-adt adt*)
      (if (equal? (car adt*)
		  '(string-append **Similix-library** "scheme.adt"))
	  (cdr adt*)
	  (_sim-error '_sim-postprocess!
		      "Internal error: first adt not scheme.adt")))
    
    ;------------------------------------------------------------------------
    
    (define (my-append! x y)
      (if (null? x)
	  y
	  (_sim-append! x y)))
    
    ;------------------------------------------------------------------------
    ; main:

    (if (> **Similix-verbose-spec** 0)
	(begin (newline)
	       (display "postprocessing ")
	       (_sim-flush-output-port)))
    
    (let ((pgm
	   (begin
	     ; the goal procedure must be kept even though its counter
	     ; specifies that there is only one call to it; therefore
	     ; the counter is set (arbitrarily) to 10000
	     (_sim-list-set! (seenb4-assoc
			      (_sim-residfetch-def-name (car res-def*))
			      **Similix-seenb4**)
			     3 10000)
	     
             (let loop ((d* res-def*))
	       (if (null? d*)
		   '()
		   (let ((d (car d*))
			 (rest (lambda () (loop (cdr d*)))))
		     (if (and **Similix-postunfold**
			      (= (list-ref (seenb4-assoc
					    (_sim-residfetch-def-name d)
					    **Similix-seenb4**)
					   3)
				 1))
			 (rest)
			 (cons (abs->conc-d (reduce-d (car d*) res-def*))
			       (rest)))))))))

      ; change goal definition from (define (_sim-goal-0 ...) ...) to
      ; (define (residual-goal ...) ...)
      (set-car! (cadr (car pgm)) (make-residual-goal-name goal residual-goal))
      
      (let* ((goal-def (car pgm))
	     (rest (cdr pgm))
	     ; make all definitions except the goal definition local:
	     ; (define (_sim-goal-0 ...) ...) d* --->
	     ; (define (_sim-goal-0 ...) d* ...)
	     (pgm (list (cons (car goal-def)
			      (cons (cadr goal-def)
				    (my-append! rest (cddr goal-def)))))))
	(my-append!
	 (map (lambda (adt) (list 'loadt adt)) (remove-scheme-adt adt*))
	 (my-append! (map (lambda (adt) (list 'loadt adt)) additional-adt*)
		     pgm))))))

;----------------------------------------------------------------------------
