(require "bugs")
(require "bcode")
(define fudd-top-level-cont (bg-convert (bg-test 'top-level) #f #t))

(define (frames->sexp cnode)
  (cond
   ((bg-clambda? cnode)
    (let ((fr (bg-clambda-frame cnode)))
      (cons (list (bg-clambda-name cnode)
		  (bg-clambda-closure cnode)
		  (cons 'clovars: (map bg-var-properties-alpha-name
				       (bg-cnode-clovars cnode)))
		  (if fr
		      (if (bg-frame-parent fr)
			  (cons 'parent: (bg-clambda-name
					  (bg-frame-binding (bg-frame-parent
							     fr))))
			  'no-parent)
		      'no-frame)
		  (if fr
		      (cons 'framed: (map bg-var-properties-alpha-name
					  (bg-frame-vars fr))) 
		      'no-frame))
	    (frames->sexp (bg-clambda-body cnode)))))
   ((bg-cif? cnode)
    (append (frames->sexp (bg-cif-pred cnode))
	    (frames->sexp (bg-cif-con cnode))
	    (frames->sexp (bg-cif-alt cnode))))
   ((bg-cset!-? cnode)
    (append (frames->sexp (bg-cset!-cont cnode))
	    (frames->sexp (bg-cset!-body cnode))))
   ((bg-ccombination? cnode)
    (apply append
	   (map (lambda (a) (frames->sexp a))
		(bg-ccombination-args cnode))))
   (else '())))

(define (fudd sexp)
  (printf "\\ni'll get that wascally wabbit yet...\\n")
  (pp sexp)
  (let ((opt (bg-test sexp)))
    (printf " =opt=> \\n")
    (pp (bg-node->sexp opt #f '()))
    (let ((cps (bg-convert opt fudd-top-level-cont #t)))
      (bg-cenv-analyze! cps '() #f)
      (bg-bind-analyze! cps #f #f)
      (bg-close-analyze! cps #f)
      (printf " =cps=> \\n")
      (pp (bg-cnode->sexp cps
			  '()
			  '()
			  '()
			  #t))
;      (printf " =cps=> \\n")
;      (pp (bg-cnode->sexp cps
;			  '()
;			  '()
;			  '()))
      (printf " w/environment structure:\\n")
      (pp (frames->sexp cps)))))

(define (fudd1 sexp)
  (printf "\\ni'll get that wascally wabbit yet...\\n")
  (pp sexp)
  (let ((opt (bg-test sexp)))
    (printf " =opt=> \\n")
    (pp (bg-node->sexp opt #f '()))
    (let ((cps (bg-convert opt (and #f fudd-top-level-cont) #t)))
      (bg-cenv-analyze! cps '() #f)
      (bg-bind-analyze! cps #f #f)
      (bg-close-analyze! cps #f)
      (printf " =cps=> \\n")
      (pp (bg-cnode->sexp cps
			  '()
			  '()
			  '()
			  #t))
;      (printf " =cps=> \\n")
;      (pp (bg-cnode->sexp cps
;			  '(name closure cont?)
;			  '(tvars)
;			  '(alpha-name)))
      (pp (cons 'bytecode
		(bg-compile-loop
		 '() (list (cons cps (cons 'global-env '()))))))
      (printf " w/environment structure:\\n")
      (pp (frames->sexp cps)))))



(error "fudd functions loaded")

(fudd '474)
(fudd 'x)
(fudd '(lambda (x) x))
(fudd '(lambda () x))
(fudd '(fn a b))
(fudd '(a-prim a b))
(fudd '((lambda (a b) (if a (a-prim a) (a-prim b))) (a-prim 3) (a-prim 5)))
(fudd '(set! q ((lambda (a b) (if a (a-prim a) (a-prim b)))
		(a-prim 3) (a-prim 5))))
(fudd '(if #t a b))
(fudd '((lambda () x)))
(fudd '((lambda (x) x) 3))
(fudd '((lambda (a b) b) 1 2))
(fudd '(if (if a b c) d e))
(fudd '((lambda (r) (if pred1 (r) #f)) (lambda () pred2)))
; macro expansion of (if (and pred1 pred2) (print 'win) (error 'lose)):
(fudd '(if ((lambda (v r) (if v (r) #f))
	    pred1
	    (lambda () pred2))
	   (print 'win)
	   (error 'lose)))

(fudd '((lambda (ignore body) (body)) ; binder for letrec
	(set! iter iter-val)
	body))

(fudd '((lambda (iter-val body)
	  ((lambda (ignore) (body)) (set! iter iter-val)))
	3
	b))

(fudd '((lambda (iter-val body)
	  ((lambda (ignore body) (body)) ; binder for letrec
	   (set! iter iter-val)
	   body))
	a b))

(fudd '(lambda (iter)
	 ((lambda (iter-val body)
	    ((lambda (ignore body) (body)) ; binder for letrec
	     (set! iter iter-val)
	     body))
	  a b)))

(fudd '(lambda (iter)
	 ((lambda (iter-val body)
	    ((lambda (ignore body) (body)) ; binder for letrec
	     (set! iter iter-val)
	     body))
	  (lambda (n total) ; real value for iter
	    (if (= n 0)
		total
		(iter (1- n) (* n total))))
	  (lambda () (iter n 1)))))	; body of letrec


; macro expansion of an iterative factorial:
;
;(lambda (n)
;  (letrec ((iter (lambda (n total)
;		   (if (= n 0)
;		       total
;		       (iter (1- n) (* n total))))))
;    (iter n 1)))
;
(fudd '(lambda (n)
	 ((lambda (iter)	; letrec
	    ((lambda (iter-val body)
	       ((lambda (ignore body) (body)) ; binder for letrec
		(set! iter iter-val)
		body))
	     (lambda (n total) ; real value for iter
	       (if (= n 0)
		   total
		   (iter (1- n) (* n total))))
	     (lambda () (iter n 1)))) ; body of letrec
	  'undefined)))	; initial value for iter


; 
; mutually recursive fns.
;
; (lambda (x)
;   (letrec ((lr1 (lambda (b) (if (foo b) b (lr2 b))))
;            (lr2 (lambda (c) (if (bar c) c (lr1 (baz c))))))
;      (lr1 x)))
;
(fudd '(lambda (x)
	((lambda (lr1 lr2)
	   ((lambda (l1val l2val)
	      ((lambda (ign1 bod1) (bod1))
	       (set! lr1 l1val)
	       (lambda ()
		 ((lambda (ign2 bod2) (bod2))
		  (set! lr2 l2val)
		  (lambda () (lr1 x))))))
	    (lambda (b) (if (foo b) b (lr2 b)))
	    (lambda (c) (if (bar c) c (lr1 c)))))
	 'undef 'undef)))
     

;
; simple closure creation case
;
(fudd '(lambda (a b)
	 (lambda (x)
	   ((lambda (ign) (foo b a)) (set! a x)))))


;
; a better letrec translation
;  
;(letrec ((a (lambda (x) (if (= x 0) 1 (b (1- x)))))
;	 (b (lambda (x) (if (= x 0) 1 (a (1- x))))))
;  (a 4))


;(let ((a (lambda (at bt x) (if (= x 0) 1 (bt at bt (1- x)))))
;      (b (lambda (at bt x) (if (= x 0) 1 (at at bt (1- x))))))
;  (a a b 4))

(fudd '((lambda (a b) (a a b 4))
	(lambda (at bt x) (if (= x 0) 1 (bt at bt (1- x))))
	(lambda (at bt x) (if (= x 0) 1 (at at bt (1- x))))))
 
(fudd '(lambda (x)
	 (lambda ()
	   ((lambda (b) ((lambda (ign v) v) (set! x (1+ x)) b)) x))))

(fudd '(lambda (a b)
	 ((lambda (mk-counter)
	    ((lambda (acounter bcounter)
	       (lambda () (cons (acounter) (bcounter))))
	     (mk-counter a)
	     (mk-counter b)))
	  (lambda (x)
	    (lambda ()
	      ((lambda (b) ((lambda (ign v) v) (set! x (1+ x)) b)) x))))))

;
; another possible letrec
;
; (lambda (n)
;   (letrec ((addup (lambda (x) (if (= x 0) 1 (1+ (mulup (1- x))))))
;            (mulup (lambda (x) (if (= x 0) 0 (* x (addup (1- x)))))))
;    (addup n)))
;
; (lambda (n)
;    (let ((addup-raw (lambda (ad mu x) (if (= x 0) 1 (1+ (mu ad mu (1- x))))))
;          (mulup-raw (lambda (ad mu x)
;              		(if (= x 0) 0 (* x (ad ad mu (1- x)))))))
;     (let ((addup (lambda (x) (addup-raw addup-raw mulup-raw x))))
;        (addup n))))


(fudd '(lambda (n)
	 ((lambda (addup-raw mulup-raw)
	    ((lambda (addup) (addup n))
	     (lambda (x) (addup-raw addup-raw mulup-raw x))))
	  (lambda (ad mu x) (if (= x 0) 1 (1+ (mu ad mu (1- x)))))
	  (lambda (ad mu x) (if (= x 0) 0 (* x (ad ad mu (1- x))))))))

(fudd '(lambda (n)
	 ((lambda (addup-raw mulup-raw)
	    ((lambda (addup) (addup n))
	     (lambda (x) (addup-raw addup-raw mulup-raw x))))
	  'const-a
	  'const-b)))

(fudd '(lambda (c1 c2)
	       (lambda (x2) ((lambda (ad mu x)
			       (if (= x 0) 1 (1+ (mu ad mu (1- x)))))
			     c1 c2 x2))))

(fudd '(lambda () ((lambda (afn) (cons (afn 0) (afn 1))) (lambda (q) (1+ q)))))
(fudd '(lambda () ((lambda (afn) (cons (afn 0) 1)) (lambda (q) (1+ q)))))

(fudd '(lambda () (foo 1)))
(fudd '(lambda () (if (foo 1) 3 4)))
(fudd '(lambda () (if (a-prim 1) 3 4)))


; for testing code generation

; trivial forms
(fudd '474)
(fudd 'x)
(fudd '(if q 1 2))
(fudd '(set! x 3))
(fudd '(a-prim a b))
(fudd '((lambda (a b) (if a (a-prim a) (a-prim b))) (a-prim 3) (a-prim 5)))
(fudd '(set! q ((lambda (a b) (if a (a-prim a) (a-prim b)))
		(a-prim 3) (a-prim 5))))

;


(fudd1 '(lambda (x) (set! a x)))
(fudd1 '(lambda (x) (set-car! a x)))
(fudd1 '(lambda (x) ((lambda (ign) x) (set! a x))))
(fudd1 '(lambda (x) (bar x)))
(fudd1 '(lambda (x) (foo (bar x))))
(fudd1 '(lambda (x) (a-prim (bar x))))
(fudd1 '(lambda (x) (set! a (foo x))))
(fudd1 '(lambda (x) (if (bar x) (foo x) (baz x))))
(fudd1 '(lambda () (if (foo 1) 3 4)))
(fudd1 '(lambda () (if (a-prim 1) 3 4)))
(fudd1 '(lambda ()
	  ((lambda (afn) (cons (afn 0) (afn 1))) (lambda (q) (1+ q)))))
(fudd1 '(lambda () ((lambda (afn) (cons (afn 0) 1)) (lambda (q) (1+ q)))))

(fudd1 '(lambda (x)
	  ((lambda (lr1)
	     ((lambda (l1val)
		((lambda (ign1 bod1) (bod1))
		 (set! lr1 l1val)
		 1))
	      q))
	   'undef)))

(fudd1 '(lambda (x)
	  ((lambda (lr1 lr2)
	     ((lambda (l1val l2val)
		((lambda (ign1 bod1) (bod1))
		 (set! lr1 l1val)
		 (lambda ()
		   ((lambda (ign2 bod2) (bod2))
		    (set! lr2 l2val)
		    (lambda () (lr1 x))))))
	      (lambda (b) (if (foo b) b (lr2 b)))
	      (lambda (c) (if (bar c) c (lr1 c)))))
	   'undef 'undef)))

(fudd1 '(lambda (x) ((lambda (q) (cons q q)) (lambda () x))))
(fudd1 '(lambda (x) ((lambda (q) (cons q 3)) (lambda () x))))