; -*- Mode: Lisp; Syntax: Common-Lisp; Package: (SCHI :USE (LISP)); -*-
; File loadit.lisp / Copyright (c) 1991 Jonathan Rees / See file COPYING

;;;; Load script

; Will not run in:
;  Symbolics versions older than Rel 7.1
;  VAX LISP versions older than V2.2
;  Explorer versions older than 3.0

(lisp:in-package "SCHI"
		 :use '(#.(if (find-package "LISP")
			      "LISP"
			      "COMMON-LISP"))
		 :nicknames '("SCHEME-INTERNAL"))

(export '(loadit))

; Retrofit CLtL-II lisps.  Pseudoscheme shouldn't care.

(unless (find-package "LISP")
  (let ((lisp (find-package "COMMON-LISP")))
    (rename-package lisp
		    (package-name lisp)
		    (cons "LISP"
			  (package-nicknames lisp)))))

(defvar *pseudoscheme-directory* *default-pathname-defaults*)

(defun loadit (&optional (dir *pseudoscheme-directory*))
  (setq *pseudoscheme-directory*
	(let ((dir (pathname (or dir
				 *default-pathname-defaults*))))
	  (make-pathname :name nil
			 :type nil
			 :directory (pathname-directory dir)
			 :device    (pathname-device dir)
			 :host	    (pathname-host dir))))
  (load-hacks)
  (load-runtime)
  (load-translated-translator)
  (load-reflect))

; ----- Load low-level hacks

(defvar hacks-package)

(defun load-hacks ()
  (let ((*package* (or (find-package "SCHEME-HACKS")
		       (make-package "SCHEME-HACKS"
				     :use '("LISP")
				     :nicknames '("SCHH")))))
    (setq hacks-package *package*)
    (load (pseudo-pathname "clever")
	  :verbose nil)			;Get clever file loader
    ;; Don't intern the symbol CLEVER-LOAD in the wrong package!
    (funcall (hack-symbol "CLEVER-LOAD")
	     (pseudo-pathname "hacks")
	     :compile-if-necessary t)
    ;; Create the scheme-internal package
    (funcall (hack-symbol "CLEVER-LOAD")
	     (pseudo-pathname "schi"))))

(defun hack-symbol (name)
  (intern name hacks-package))

(defun pseudo-pathname (name)
  (make-pathname :name (filename-preferred-case name)
		 :defaults *pseudoscheme-directory*))

(defun filename-preferred-case (name)
  #+unix (string-downcase name)
  #-unix (string-upcase name)
  )

; ----- Load run-time system

(defparameter lisp-package-foo nil)

(defparameter revised^4-scheme-package nil)

(defun load-runtime ()
  (let ((package (or (find-package "SCHEME")
		     (make-package "SCHEME" :use '()))))
    (funcall (hack-symbol "FIX-SCHEME-PACKAGE-IF-NECESSARY") package)
    #+Symbolics
    (pushnew package si:*reasonable-packages*))

  (setq lisp-package-foo
	(symbol-value (intern "LISP-PACKAGE" "SCHEME-HACKS")))

  (setq revised^4-scheme-package
	(or (find-package "REVISED^4-SCHEME")
	    (make-package "REVISED^4-SCHEME" :use (list lisp-package-foo))))

  (mapc #'load-runtime-file
	'("readtable"
	  "core"			;for STRING->SYMBOL
	  ;; REP loop and related things
	  "rts"
	  ))

  (load-translated "closed" revised^4-scheme-package)

  ;; read and write are optional.  Loading "read" gets you ... and colons.
  ;; Loading "write" gets you these plus (), #t, and #f.
  ;; The downside of using "read" is that it becomes nearly impossible
  ;; to refer to Common Lisp functions, variables, and symbols from
  ;; Scheme code.
  ;; (load-translated "read" revised^4-scheme-package)
  ;; (load-translated "write" revised^4-scheme-package)

  'done)

(defvar this-package *package*)

(defun load-runtime-file (filespec)
  (let ((*package* this-package))
    (funcall (hack-symbol "CLEVER-LOAD")
      (pseudo-pathname (if (consp filespec) (car filespec) filespec))
      :compile-if-necessary (not (consp filespec)))))

(defun load-translated (file package)
  ;; PSO stands for Pseudo-Scheme Object file
  (let ((*target-package* package))	;cf. scheme-load
    (declare (special *target-package*))
    (funcall (hack-symbol "CLEVER-LOAD") (pseudo-pathname file)
	     :source-type *translated-file-type*
	     :compile-if-necessary t)))

; ----- Load translator

(defparameter scheme-translator-package nil)
(defparameter translator-files nil)

(defun load-translated-translator ()
  (setq scheme-translator-package
	(or (find-package "SCHEME-TRANSLATOR")
	    (make-package "SCHEME-TRANSLATOR"
			  :use (list revised^4-scheme-package
				     lisp-package-foo))))
  (setq translator-files
	(with-open-file (s (pseudo-pathname "translator.files"))
	  (read s)))
  (mapc #'(lambda (file)
	    (load-translated file scheme-translator-package))
	translator-files)
  'done)

(defun load-reflect ()
  (load-translated "REFLECT" scheme-translator-package)
  (load-runtime-file "EVAL")
  #+Lispm
  (load-runtime-file "CUSTOM"))
