; File builtin.scm / -*- Mode: Scheme; Syntax: Scheme; Package: Scheme; -*-
; Copyright (c) 1991 Jonathan Rees / See file COPYING

;;;; Compilation of calls to built-in Scheme procedures

; The usual integrations

; An entry in the integrations table is a pair, one of the following:
;   (FUN foo)            - translate as #'foo or (foo ...)
;   (PRED foo)		 - translate calls as (schi:true? (foo ...))
;   (SUBST bvl body)     - translate calls as appropriate
;   (LAMBDA bvl body)    - ditto
;   (CASE-AUX)	         - a special case kludge

; The integrations table is indexed by Common Lisp symbols.

(define integrations-table (make-table))

(define (define-integration! var int)
  (table-set! integrations-table var int))

(for-each (lambda (z)
	    (define-integration!
	      (program-env-lookup revised^4-scheme-env (car z))
	      (cadr z)))
    `(
      (*                              (fun lisp:*))
      (+                              (fun lisp:+))
      (-                              (fun lisp:-))
      (/                              (fun lisp:/))
      (<=                             (pred lisp:<=))
      (<                              (pred lisp:<))
      (=                              (pred lisp:=))
      (>=                             (pred lisp:>=))
      (>                              (pred lisp:>))
      (abs                            (fun lisp:abs))
      (acos                           (fun lisp:acos))
      (angle                          (fun lisp:phase))
      (append                         (fun lisp:append))
      (apply                          (fun lisp:apply))
      (asin                           (fun lisp:asin))
      (assoc
       (subst (obj list)
	 (schi:true? (lisp:assoc obj list
				 :test (lisp:function schi:scheme-equal-p)))))
      (assq
       (subst (obj list)
	 (schi:true? (lisp:assoc obj list :test (lisp:function lisp:eq)))))
      (assv                           (pred lisp:assoc 2))
      (atan                           (fun lisp:atan))
      (boolean?			      (pred schi:booleanp 1))
      (caaaar                         (fun lisp:caaaar))
      (caaadr                         (fun lisp:caaadr))
      (caaar                          (fun lisp:caaar))
      (caadar                         (fun lisp:caadar))
      (caaddr                         (fun lisp:caaddr))
      (caadr                          (fun lisp:caadr))
      (caar                           (fun lisp:caar))
      (cadaar                         (fun lisp:cadaar))
      (cadadr                         (fun lisp:cadadr))
      (cadar                          (fun lisp:cadar))
      (caddar                         (fun lisp:caddar))
      (cadddr                         (fun lisp:cadddr))
      (caddr                          (fun lisp:caddr))
      (cadr                           (fun lisp:cadr))
      (call-with-current-continuation
	  (subst (proc)
	    (lisp:block continuation
	      (lisp:funcall proc
		  (lisp:function (lisp:lambda (val)
				   (lisp:return-from continuation val)))))))
      (call-with-input-file
	  (lambda (string proc)
	    (lisp:with-open-file (port (lisp:merge-pathnames string)
				       :direction :input)
	      (lisp:funcall proc port))))
      (call-with-output-file
	  (lambda (string proc)
	    (lisp:with-open-file (port (lisp:merge-pathnames string)
				       :direction :output
				       :if-exists :new-version)
	      (lisp:funcall proc port))))
      (call-with-values
	  (subst (thunk proc)
	    (lisp:multiple-value-call proc (lisp:funcall thunk))))
      (car                            (fun lisp:car))
      (cdaaar                         (fun lisp:cdaaar))
      (cdaadr                         (fun lisp:cdaadr))
      (cdaar                          (fun lisp:cdaar))
      (cdadar                         (fun lisp:cdadar))
      (cdaddr                         (fun lisp:cdaddr))
      (cdadr                          (fun lisp:cdadr))
      (cdar                           (fun lisp:cdar))
      (cddaar                         (fun lisp:cddaar))
      (cddadr                         (fun lisp:cddadr))
      (cddar                          (fun lisp:cddar))
      (cdddar                         (fun lisp:cdddar))
      (cddddr                         (fun lisp:cddddr))
      (cdddr                          (fun lisp:cdddr))
      (cddr                           (fun lisp:cddr))
      (cdr                            (fun lisp:cdr))
      (ceiling                        (fun lisp:ceiling))
      (char->integer                  (fun lisp:char-code))
      (char-alphabetic?               (pred lisp:alpha-char-p 1))
      (char-ci<=?                     (pred lisp:char-not-greaterp))
      (char-ci<?                      (pred lisp:char-lessp))
      (char-ci=?                      (pred lisp:char-equal))
      (char-ci>=?                     (pred lisp:char-not-lessp))
      (char-ci>?                      (pred lisp:char-greaterp))
      (char-downcase                  (fun lisp:char-downcase))
      (char-lower-case?               (pred lisp:lower-case-p 1))
      (char-numeric?                  (pred lisp:digit-char-p 1))
      (char-ready?		      (pred lisp:listen))
      (char-upcase                    (fun lisp:char-upcase))
      (char-upper-case?               (pred lisp:upper-case-p 1))
      (char-whitespace?		      (pred schi:char-whitespace-p 1))
      (char<=?                        (pred lisp:char<=))
      (char<?                         (pred lisp:char<))
      (char=?                         (pred lisp:char=))
      (char>=?                        (pred lisp:char>=))
      (char>?                         (pred lisp:char>))
      (char?                          (pred lisp:characterp 1))
      (close-input-port               (fun lisp:close))
      (close-output-port              (fun lisp:close))
      (complex?                       (pred lisp:numberp 1))
      (cons                           (fun lisp:cons))
      (cos                            (fun lisp:cos))
      (current-input-port
       (subst () lisp:*standard-input*))
      (current-output-port
       (subst () lisp:*standard-output*))
      (denominator                    (fun lisp:denominator))
      (eof-object?
       (subst (obj)
	 (schi:true? (lisp:eq obj schi:eof-object))))
      (eq?                            (pred lisp:eq 2))
      (equal?			      (pred schi:scheme-equal-p 2))
      (eqv?                           (pred lisp:eql 2))
      (even?                          (pred lisp:evenp 1))
      (exact?                         (pred lisp:rationalp 1))
      (exact->inexact                 (fun lisp:float))
      (expt                           (fun lisp:expt))
      (exp                            (fun lisp:exp))
      (floor                          (fun lisp:floor))
      (for-each                       (fun lisp:mapc))
      (gcd                            (fun lisp:gcd))
      (imag-part                      (fun lisp:imagpart))
      (inexact?                       (pred lisp:floatp 1))
      (inexact->exact                 (fun lisp:rationalize))
      (input-port?		      (pred schi:input-port-p 1))
      (integer->char                  (fun lisp:code-char))
      (integer?                       (pred lisp:integerp 1))
      (lcm                            (fun lisp:lcm))
      (length                         (fun lisp:length))
      (list                           (fun lisp:list))
      (list->string
       (subst (l) (lisp:coerce (lisp:the lisp:list l)
			       (lisp:quote lisp:simple-string))))
      (list->vector
       (subst (l) (lisp:coerce (lisp:the lisp:list l)
			       (lisp:quote lisp:simple-vector))))
      (list-ref
       (subst (list n) (lisp:nth n list)))
      (list-tail
       (subst (list n) (lisp:nthcdr n list)))
      (log                            (fun lisp:log))
      (magnitude                      (fun lisp:abs))
      (make-polar
       (subst (r th) (lisp:* r (lisp:cis th))))
      (make-rectangular               (fun lisp:complex))
      (map                            (fun lisp:mapcar))
      (max                            (fun lisp:max))
      (member
       (subst (obj list)
	 (schi:true? (lisp:member obj list
				  :test (lisp:function schi:scheme-equal-p)))))
      (memq
       (subst (obj list)
	 (schi:true? (lisp:member obj list :test (lisp:function lisp:eq)))))
      (memv                           (pred lisp:member 2))
      (min                            (fun lisp:min))
      (modulo                         (fun lisp:mod))
      (negative?                      (pred lisp:minusp 1))
      (newline                        (fun lisp:terpri))
      (not			      (special))
      (null?                          (pred lisp:null 1))
      (number?                        (pred lisp:numberp 1))
      (numerator                      (fun lisp:numerator))
      (odd?                           (pred lisp:oddp 1))
      (open-input-file
       (subst (string)
	 (lisp:open (lisp:merge-pathnames string) :direction :input)))
      (open-output-file
       (subst (string)
	 (lisp:open (lisp:merge-pathnames string) :direction :output)))
      (output-port?                   (pred schi:output-port-p 1))
      ;; This isn't quite right; PAIR? wants to return false for
      ;; procedures.  (Some Common Lisps implement some functions as
      ;; pairs.)  But the runtime overhead of this check would be
      ;; prohibitively high.
      (pair?                          (pred lisp:consp 1))
      (positive?                      (pred lisp:plusp 1))
      (procedure?		      (pred schi:procedurep 1))
      (quotient
       (subst (n1 n2)
	 (lisp:values (lisp:truncate n1 n2))))
      (rational?                      (pred lisp:rationalp 1))
      (real?			      (pred schi:realp 1))
      (real-part                      (fun lisp:realpart))
      (remainder                      (fun lisp:rem))
      (reverse                        (fun lisp:reverse))
      (round                          (fun lisp:round))
      (set-car!
       (subst (pair obj)
	 (lisp:setf (lisp:car pair) obj)
	 schi:unspecified))
      (set-cdr!
       (subst (pair obj)
	 (lisp:setf (lisp:cdr pair) obj)
	 schi:unspecified))
      (sin                            (fun lisp:sin))
      (sqrt                           (fun lisp:sqrt))
      (string->list
       (subst (string)
	 (lisp:coerce (lisp:the lisp:simple-string string)
		      (lisp:quote lisp:list))))
      (string->symbol
       (subst (string)
	 (lisp:values (lisp:intern string schi:scheme-package))))
      (string-ci<=?                   (pred lisp:string-not-greaterp 2))
      (string-ci<?                    (pred lisp:string-lessp 2))
      (string-ci=?                    (pred lisp:string-equal 2))
      (string-ci>=?                   (pred lisp:string-not-lessp 2))
      (string-ci>?                    (pred lisp:string-greaterp 2))
      (string-copy                    (fun lisp:copy-seq))
      (string-fill!
       (subst (s val)
	 (lisp:fill (lisp:the lisp:simple-string s) val)))
      (string-length
       (subst (s)
         (lisp:length (lisp:the lisp:simple-string s))))
      (string-ref
       (subst (s k)
	 (lisp:char (lisp:the lisp:simple-string s) k)))
      (string-set!
       (subst (s k obj)
	 (lisp:setf (lisp:char (lisp:the lisp:simple-string s) k) obj)
	 schi:unspecified))
      (string<=?                      (pred lisp:string<= 2))
      (string<?                       (pred lisp:string< 2))
      (string=?                       (pred lisp:string= 2))
      (string>=?                      (pred lisp:string>= 2))
      (string>?                       (pred lisp:string> 2))
      (string?                        (pred lisp:simple-string-p 1))
      (substring                      (fun lisp:subseq))
      (symbol?			      (pred schi:scheme-symbol-p 1))
      (tan                            (fun lisp:tan))
      (transcript-off
       (subst ()
         (lisp:dribble)
	 schi:unspecified))
      (transcript-on
       (subst (filespec)
         (lisp:dribble filespec)
	 schi:unspecified))
      (truncate                       (fun lisp:truncate))
      (values                         (fun lisp:values))
      (vector                         (fun lisp:vector))
      (vector->list
       (subst (vec)
	 (lisp:coerce (lisp:the lisp:simple-vector vec)
		      (lisp:quote lisp:list))))
      (vector-fill!
       (subst (vec val)
	 (lisp:fill (lisp:the lisp:simple-vector vec) val)))
      (vector-length
       (subst (vec)
         (lisp:length (lisp:the lisp:simple-vector vec))))
      (vector-ref                     (fun lisp:svref))
      (vector-set!
       (subst (vec k obj)
	 (lisp:setf (lisp:svref vec k) obj)
	 schi:unspecified))
      (with-input-from-file
       (subst (string thunk)
      	 (lisp:with-open-file (lisp:*standard-input*
			         (lisp:merge-pathnames string)
				 :direction :input)
	   (lisp:funcall thunk))))
      (with-output-to-file
       (subst (string thunk)
	 (lisp:with-open-file (lisp:*standard-output*
			         (lisp:merge-pathnames string)
				 :direction :output
				 :if-exists :new-version)
	    (lisp:funcall thunk))))
      (write-char                     (fun lisp:write-char))
      (zero?                          (pred lisp:zerop 1))

      ;; Auxiliaries
      (unassigned (subst () schi:unassigned))
      (unspecified (val schi:unspecified))
      (and-aux (special))
      (or-aux (special))
      (=>-aux (special))
      (case-aux (special))
      ))
