/*  Copyright (C) 1989, 1988, 1987 Barak Pearlmutter and Kevin Lang */

/*
 * This file describes the configuration of the machine that is being
 * compiled on.  It deals with quirks of the CPU, compiler, and OS.
 */



/* I'd love to be able to case things out here: */

/* Length of (long).  Must be <= length of (char *). */
#define WORDSIZE 32





/* Try to figure out the endianity. */

#ifdef CMUCS

#ifdef BYTE_MSF
#define BIG_ENDIAN
#endif

#else /* not CMUCS */

#ifndef vax		/* cpp on a BSD or ULTRIX vax thinks big endian! */
#ifndef mips		/* as does Ultrix on a DEC 3100. */

#ifdef mac
#define BIG_ENDIAN
#else

/* This 'A\0' business here doesn't usually work. */
#if ('A\0' == 0x41)
#define BIG_ENDIAN
#endif

#endif /* mac */
#endif /* mips */
#endif /* vax */

#endif CMUCS





/* UNALIGNED should be defined if malloc() might return a pointer that isn't
   long aligned, ie, whose low two bits might not be 0. */

#ifdef mac
#define UNALIGNED
#endif






/* Expand this to include all systems with unsigned chars: */

#ifdef ibmrt
#define UNSIGNED_CHARS
#endif




/* unix_files is defined if things like ftell() and fseek() are
   around.  For things like fileno() and isatty() we need real unix. */

#ifdef unix
#define unix_files
#endif unix

#ifdef Mac_LSC
#define unix_files
#define MALLOC_STACK_BUFFER 
#define MALLOC_WP_TABLE
#define PROTOTYPES
#define CANT_FLUSH_STD
#define mac
#endif Mac_LSC




/* Machines with int's smaller than char *'s should not define this. */
#ifndef Mac_LSC
#define BIGINT
#endif




/* The following can be ((x)>>2) on machines with arithmetic right
   shifts of signed numbers.  Regrettably, some machines (like the
   Convex) treat all numbers being shifted as unsigned.  If your
   compiler emits better code for (x>>2) than for (x/4) and does not
   have this weird problem, you should use the definition that is
   commented out. */

#define ASHR2(x) ((x)/4)
/* #define ASHR2(x) ((x)>>2) */




/* Some machines have a 64 bit variant of long called a "long long",
   which makes multiplication overflow detection easier. */

#ifdef convex
#define HAVE_LONG_LONG
#endif




/* On some machines we use floating point hardware to detect
   overflows.  This doesn't seem to be a win on any tested system, and is
   therefore commented out.  */

#ifndef HAVE_LONG_LONG
/* #define DOUBLES_FOR_OVERFLOW */
#endif




/* eof */
