;;; Copyright (C) 1988, Barak Pearlmutter & Kevin Lang, CMU Oaklisp Project.

(herald start (env t))

;;; Lists of files that the world is made of:

;;; Keep the loader from printing all this crap:

(define between-files '(st da pl do))

(let ((kernel-files
       '(
	 cold-booting
	 kernel0 do
	 kernel0types do
	 kernel1-install do
	 kernel1-funs do
	 kernel1-make do
	 kernel1-freeze do
	 kernel1-maketype pl
	 kernel1-inittypes pl
	 kernel1-segments pl
	 super pl
	 kernel pl
	 ))
      (layer1
       '(
	 mix-types st
	 operations st
	 ops st
	 truth st
	 logops st
	 consume st
	 conses st
	 coerce st
	 ))
      (layer2
       '(
	 eqv pl
	 mapping pl
	 fastmap pl
	 fluid pl
	 vector-type pl
	 vl-mixin pl
	 numbers pl
	 subtypes pl
	 weak pl
	 strings pl
	 sequences pl
	 ))
      (layer3
       '(
	 undefined da
	 subprimitive da
	 tag-trap da
	 code-vector da
	 hash-table da
	 format da
	 signal pl
	 error da
	 symbols da
	 print-noise da
	 patch-symbols da
	 predicates da
	 ))
      (layer4
       '(
	 print do
	 print-integer do
	 print-list do
	 reader-errors do
	 reader do
	 reader-macros do
	 hash-reader pl
	 read-char pl
	 locales do
	 expand do
	 make-locales do
	 patch-locales do
	 freeze do
	 bp-alist do
	 describe do
	 warm do
	 interpreter pl
	 top-level pl
	 booted st
	 dump-stack do
	 destructure do
	 macros1 do
	 macros2 do
	 icky-macros do
	 obsolese do
	 define do
	 file-errors do
	 streams do
	 cold do			;cold load streams
	 nargs pl
	 has-method pl
	 op-error pl
	 error2 pl
	 error3 pl
	 backquote pl
	 file-io pl
	 fasl pl
	 load-oaf pl
	 load-file pl
	 string-stream pl
	 list pl
	 catch da
	 continuation da
	 unwind-protect da
	 ))
      (layer5
       '(
	 bounders do
	 anonymous pl
	 sort pl
	 exit pl
	 ))
      (layer6
       '(
	 export
	 st st st cold-boot-end
	 )))

  (define all-the-layers
    (append kernel-files layer1 layer2 layer3 layer4 layer5 layer6)))


;;; not built into world

(define compiler-files
  '(
    mac-comp-stuff
    mac-compiler-nodes 
    mac-compiler1 
    mac-compiler2 
    mac-compiler3 
    mac-code 
    peephole 
    assembler
    file-compiler
    compiler-exports
    ))

(define batch-compiler-file '(batch-compiler))

;;; Not in the cold world, but should included in the world

(define misc-files
  '(
    promise
    bignum
    bignum2
    rational
    complex
    rounding
    lazy-cons
    math
    trace
    apropos
    time
    ;; pretty-print
    ))

;; On machines that make programs handle backspace, load streams-bs
;; into the world.  It depends on continuations, so be wary of putting
;; it into the cold world.

;;; eof
