
/*  Copyright (C) 1987 Barak Pearlmutter and Kevin Lang    */


#include <stdio.h>
#include <ctype.h>
#include "emulator.h"


/* These are for making the world seem contiguous in dumps even if it
   isn't really. */


#define contigify(r) ((r)&0x2 ? (r)-(ref)new_space : (r))
#define CONTIGIFY(v) if ((v)&2) (v) -= (ref)new_space


bool dump_decimal= FALSE;	/* dumped worlds in base 10 (not 16) */
bool dump_binary = FALSE;	/* dumped worlds in base 2  (not 16) */


/*
 * Format of Oaklisp world image:
 *
 * <size of value stack>
 * <size of context stack>
 * <reference to code body for booting>
 * <number of words to load>
 *
 * <words to load>
 *
 * <size of weak pointer table>
 * <contents of weak pointer table>
 */

/*
 * emulator state
 */


unsigned long val_stk_size;
unsigned long cxt_stk_size;
unsigned long new_space_size;
unsigned long load_mem_size;



char control_string_dec[] = "%ld ";
char control_string_hex[] = "%lx ";

bool input_is_binary;


long nrefs_in_buf = 0;
ref *next_ref_in_buf;


#define REFBUFSIZ 1024
ref refbuf[REFBUFSIZ];


ref read_ref(d)  /* Read a reference from a file: */
     FILE *d;
{
  int c;
  ref a=0;

  /* It's easy to read a reference from a binary file. */
  if (input_is_binary) {
    if (nrefs_in_buf == 0) {
      nrefs_in_buf = fread (refbuf, sizeof(ref), REFBUFSIZ, d);
      next_ref_in_buf = refbuf;
    }
    a = *next_ref_in_buf++;
    nrefs_in_buf--;
    return a;
  }

#ifdef BIG_ENDIAN
  while ( isspace(c=getc(d)) || c=='^' )
#else
  while ( isspace(c=getc(d)) )
#endif
    if (c == EOF)
      {
	(void)printf("Apparently truncated cold load file!\n");
	exit(1);
      }
  {
#ifndef BIG_ENDIAN
    bool swapem;

    if (swapem = (c == '^'))
      {
	c = getc(d);
	if (c == EOF)
	  {
	    (void)printf("Apparently truncated cold load file!\n");
	    exit(1);
	  }
      }
#endif

    while (isxdigit(c))
      {
	a = a<<4;
	if (c <= '9')
	  a |= c-'0';
	else if (c <= 'Z')
	  a |= c-'A'+10;
	else
	  a |= c-'a'+10;
	c = getc(d);
      }

#ifndef BIG_ENDIAN
    if (c=='^') ungetc(c,d);

    if (swapem)
      a = a<<16 | a>>16;
#endif
    
    return a;
  }
}




FILE *prompt_file(the_prompt,mode)
char *the_prompt,*mode;
{
  char filename[80];
  FILE * workfp;
  bool success=TRUE;
  do {if (!success) (void)fprintf(stderr,"Can't open %s.\n",filename);
      (void)printf (the_prompt);
      (void)scanf ("%s", filename);
      success = ((workfp = fopen (filename, mode)) != NULL);
  } while (!success);
  return (workfp);
}


void dump_binary_world()
{
  FILE *wfp;
  ref *memptr;
  ref theref;
  int imod = 0;
  unsigned long worlsiz = free_point - new_space;

  wfp = prompt_file("world file to write: ", WRITE_BINARY_MODE);

  putc('\002', wfp);  putc('\002', wfp);  putc('\002', wfp);  putc('\002', wfp);
  fwrite (&val_stk_size, sizeof(unsigned), 1, wfp);
  fwrite (&cxt_stk_size, sizeof(unsigned), 1, wfp);
  theref = contigify(e_boot_code);
  fwrite (&theref, sizeof(unsigned), 1, wfp);
  fwrite (&worlsiz, sizeof(unsigned), 1, wfp);

  for (memptr = new_space; memptr < free_point; memptr++) {
    theref = *memptr;
    CONTIGIFY(theref);
    refbuf[imod++] = theref;
    if (imod == REFBUFSIZ) {
      fwrite (refbuf, sizeof(ref), imod, wfp);
      imod = 0;
    }
  }
  if (imod != 0)
    fwrite (refbuf, sizeof(ref), imod, wfp);


  /* Write the weak pointer table. */

  {
    ref r_wp_index = (ref)wp_index;
    
    fwrite(&r_wp_index, sizeof(ref), 1, wfp);
  }
  

  for (imod = 0; imod<wp_index; imod++)
    {
      theref = wp_table[imod];
      CONTIGIFY(theref);
      fwrite(&theref, sizeof(ref), 1, wfp);
    }


  (void)fclose(wfp);
}


void dump_world()
{
  FILE *wfp;
  char *control_string;
  ref *memptr;
  int eighter = 0, i;
  ref theref;

  if (dump_binary) dump_binary_world();
  else
    {control_string = (dump_decimal ? control_string_dec : control_string_hex);
     wfp = prompt_file("world file to write: ", WRITE_MODE);
     (void)fprintf(wfp, control_string, val_stk_size);
     (void)fprintf(wfp, control_string, cxt_stk_size);
     (void)fprintf(wfp, control_string, contigify(e_boot_code));
     (void)fprintf(wfp, control_string, free_point - new_space);
     for (memptr = new_space; memptr < free_point; memptr++) {
       if (eighter == 0) (void)fprintf(wfp, "\n");
       theref = *memptr;
       CONTIGIFY(theref);
       (void)fprintf(wfp,control_string, theref);
       eighter = (eighter + 1) % 8;
     }
     (void)fprintf(wfp, "\n");


     /* Write the weak pointer table. */
     
     (void)fprintf(wfp, control_string, wp_index);
     
     eighter = 0;
     
     for (i = 0; i<wp_index; i++)
       {
	 if (eighter == 0) (void)fprintf(wfp, "\n");
	 theref = wp_table[i];
	 CONTIGIFY(theref);
	 (void)fprintf(wfp, control_string, theref);
	 eighter = (eighter + 1) % 8;
       }
     
     (void)fclose(wfp);
   }
}



void read_world(str)
     char *str;
{
  FILE *d;
  int magichar;

  

  d = fopen(str, READ_BINARY_MODE);

  if (d==NULL)
    {
      (void)printf("Can't open '%s'.\n", str);
      exit(1);
    }

  magichar = getc (d);
  if (magichar == 2) {
    getc(d);getc(d);getc(d);
    input_is_binary = 1;
  }
  else
    {
      (void)ungetc (magichar, d);
      input_is_binary = 0;
#ifdef BIG_ENDIAN
      printf("Big Endian.\n");
#else
      printf("Little Endian.\n");
#endif
    }


  val_stk_size  = read_ref(d);
  cxt_stk_size  = read_ref(d);
  e_boot_code   = read_ref(d);
  load_mem_size = read_ref(d);

  new_space = (ref *) my_malloc( new_space_size*sizeof(ref) );
  free_point = new_space + load_mem_size;
  end_of_new_space = new_space + new_space_size;

  e_boot_code += (ref)new_space;

  {
    unsigned long load_count;
    ref *mptr, next;
    load_count = load_mem_size;
    mptr = new_space;
    
    if (input_is_binary)
      {
	while (load_count != 0)
	  {
	    if (nrefs_in_buf == 0) {
	      nrefs_in_buf = fread (refbuf, sizeof(ref), REFBUFSIZ, d);
	      next_ref_in_buf = refbuf;
	    }
	    next = *next_ref_in_buf++;
	    nrefs_in_buf--;
	    if ( next&2 ) next += (ref)new_space;
	    *mptr++ = next;
	    --load_count;
	  }
    }
    else
      {
	while (load_count != 0)
	  {
	    next = read_ref(d);
	    if ( next&2 ) next += (ref)new_space;
	    *mptr++ = next;
	    --load_count;
	  }
      }
    /* Load the weak pointer table. */
    wp_index = read_ref(d);
    for (load_count=0; load_count<wp_index; load_count++)
      {
	next = read_ref(d);
	if (next&2) next += (ref)new_space;
	wp_table[load_count] = next;
      }
  }
  (void)fclose(d);
}





unsigned long string_to_int(string) /* for decoding command line */
char string[];     
{
  long n = 0;
  char *cs = string;
  while(*cs >= '0' && *cs <= '9')
    n = n*10 + *cs++ - '0';
  while (1)
    switch(*cs++)
      {
      case 'k':
	n *= 1024;
	continue;
      case 'M':
	n *= (1024 * 1024);
	continue;
      case 'w':
	n *= sizeof(ref);
	continue;
      case '\0':
	return(n);
      }
}

