
; this file no longer needs to exist since it has been incorporated into the file tool.t

(herald string-alloc (env t))

; don't compile this file

(define-local-syntax (tagize-int x)  `(+ int-tag (* ,x 4)))
(define-local-syntax (tagize-ptr x)  `(+ ptr-tag (* ,x 4)))

(define-local-syntax (zero-enough? x) `(or (eq? ,x 0) (alikeq? ,x '(0 . 0))))

(define-local-syntax (store-world-word word word-addr)
  `(let ((oldword (vref world ,word-addr)))
     (if (zero-enough? oldword)
	 (set (vref world ,word-addr) ,word)
	 (error "attempted overwrite <~s ~s> ~&" ,word ,word-addr))))

(define-local-syntax (store-world-int x word-addr) `(store-world-word (tagize-int ,x) ,word-addr))
(define-local-syntax (store-world-ptr x word-addr) `(store-world-word (tagize-ptr ,x) ,word-addr))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(define (string-alloc c)
  (let* ((strlen (string-length c))
	 (strwordlen (+ 3 (quotient (+ strlen (- 3 1)) 3)))
	 (newstring (alloc-dat  strwordlen))
	 (strlist (map char->ascii (string->list c))))
;   (toble-probe c string-table)
;   (set (contents (toble-probe c string-table)) newstring);
    (store-world-ptr where-string-lives newstring)
    (store-world-int strwordlen  (+ 1 newstring))
    (store-world-int strlen  (+ 2 newstring))
    (string-alloc-aux (+ 3 newstring) strlist strlen)
    (tagize-ptr newstring)))


(define (string-alloc-aux i l to-do)
  (iterate aux ((i i)(l l)(to-do to-do))
    (cond ((= to-do 0) nil)
	  ((= to-do 1)
	   (store-world-int (car l) i))
	  ((= to-do 2)
	   (store-world-int (logior (car l) (ash (cadr l) 8)) i))
	  (t
	   (let* ((c0 (car l))
		  (l1 (cdr l))
		  (c1 (car l1))
		  (l2 (cdr l1))
		  (c2 (car l2)))
	     (store-world-int (logior c0 (logior (ash c1 8) (ash c2 16))) i)
	     (aux (+ i 1) (cdr l2) (- to-do 3)))))))






