
; don't compile this file

(herald string-alloc (env t))

(define (string-alloc c)
  (let* ((strlen (string-length c))
	 (strwordlen (+ 3 (div (+ strlen (- 3 1)) 3)))
	 (newstring (alloc-dat  strwordlen))
	 (strlist (map char->ascii (string->list c))))
    (toble-probe c string-table)
    (set (contents (toble-probe c string-table)) newstring)
    (store-world-ptr where-string-lives newstring)
    (store-world-int strwordlen  (+ 1 newstring))
    (store-world-int strlen  (+ 2 newstring))
    (iterate aux ((i (+ 3 newstring))(l strlist)(to-do strlen))
      (cond ((= to-do 0) nil)
	    ((= to-do 1)
	     (store-world-int (car l) i))
	    ((= to-do 2)
	     (store-world-int (logior (car l) (ash (cadr l) 8)) i))
	    (t
	     (let* ((c0 (car l))
		    (l1 (cdr l))
		    (c1 (car l1))
		    (l2 (cdr l1))
		    (c2 (car l2)))
	       (store-world-int (logior c0 (logior (ash c1 8) (ash c2 16))) i)
	       (aux (+ i 1) (cdr l2) (- to-do 3))))))
    (tagize-ptr newstring)))


(define (dump-tables file-symbol)
  (with-open-streams ((outfile (open (->filename file-symbol) '(out))))
      (pretty-print
       (list `(variables ,(reverse (toble->alist var-table)))
	     `(symbols   ,(reverse (toble->alist sym-table)))
	     `(strings   ,(reverse (toble->alist string-table))))
       outfile)))
