
(define (count-things inlist)
  (set dat-count 0)
  (set blk-count 0)
  (set opc-count (- reg-code-delta top-code-delta)) ; header for top code blk
  (walk count-variable vars-to-preload)
  (walk (lambda (fil)
	  (let ((nblks (length fil)))
	    (set opc-count (fx+ opc-count
				(fx+ top-code-delta
				     (fx* reg-code-delta (fx- nblks 1)))))
	    (set max-blks (max nblks max-blks))
	    (set blk-count (fx+ nblks blk-count))
	    (walk (lambda (blk)
		    (print-dot)
		    (count-opcodes blk)
		    (walk (lambda (x)
			    (let ((keyword (first x)))
			      (cond ((eq? 2 keyword);constant
				     (count-data (third x))
				     )
				    ((eq? 0 keyword);variable
				     (count-variable (third x)))
				    ((eq? 1 keyword);code
				     nil)
				    ((eq? 'constant keyword)
				     (count-data (third x))
				     )
				    ((eq? 'variable keyword)
				     (count-variable (third x)))
				    ((eq? 'code keyword)
				     nil)
				    (else
				     (error "bad inline patch keyword ~s ~&" keyword))
				    )))
			  (first blk)))
		  fil)))
	inlist))

