/*  Copyright (C) 1987 Barak Pearlmutter and Kevin Lang    */


#include <stdio.h>
#include <ctype.h>
#include "emulator.h"


/* These are for making the world seem contiguous and zero-based in dumps
   even if it isn't really. */


ref contig(r, just_new)
     ref r;
{
  ref *p = ANY_TO_PTR(r);

  if (just_new)
    if (NEW_PTR(p))
      return (p - new.start)*4 | r&3;
    else
      printf("Non-new pointer %ld found.\n", r);
  else if (SPATIC_PTR(p))
    return (p - spatic.start)*4 | r&3;
  else if (NEW_PTR(p))
    return (p - new.start + spatic.size)*4 | r&3;
  else
    printf("Non-new or spatic pointer %ld found.\n", r);

  return r;
}

#define contigify(r) ((r)&0x2 ? contig((r),just_new) : (r))
#define CONTIGIFY(v) { if ((v)&2) (v) = contig((v),just_new); }


bool dump_decimal= FALSE;	/* dumped worlds in base 10 (not 16) */
bool dump_binary = FALSE;	/* dumped worlds in base 2  (not 16) */


/*
 * Format of Oaklisp world image:
 *
 * <size of value stack>
 * <size of context stack>
 * <reference to code body for booting>
 * <number of words to load>
 *
 * <words to load>
 *
 * <size of weak pointer table>
 * <contents of weak pointer table>
 */

/*
 * emulator state
 */





char control_string_dec[] = "%ld ";
char control_string_hex[] = "%lx ";

bool input_is_binary;


long nrefs_in_buf = 0;
ref *next_ref_in_buf;


#define REFBUFSIZ 1024
ref refbuf[REFBUFSIZ];


ref read_ref(d)  /* Read a reference from a file: */
     FILE *d;
{
  int c;
  ref a=0;

  /* It's easy to read a reference from a binary file. */
  if (input_is_binary) {
    if (nrefs_in_buf == 0) {
      nrefs_in_buf = fread (&refbuf[0], sizeof(ref), REFBUFSIZ, d);
      next_ref_in_buf = refbuf;
    }
    a = *next_ref_in_buf++;
    nrefs_in_buf--;
    return a;
  }

#ifdef BIG_ENDIAN
  while ( isspace(c=getc(d)) || c=='^' )
#else
  while ( isspace(c=getc(d)) )
#endif
    if (c == EOF)
      {
	(void)printf("Apparently truncated cold load file!\n");
	exit(1);
      }
  {
#ifndef BIG_ENDIAN
    bool swapem = c == '^';

    if (swapem)
      if ((c = getc(d)) == EOF)
	{
	  (void)printf("Apparently truncated cold load file!\n");
	  exit(1);
	}
#endif

    while (isxdigit(c))
      {
	a = a<<4;
	if (c <= '9')
	  a |= c-'0';
	else if (c <= 'Z')
	  a |= c-'A'+10;
	else
	  a |= c-'a'+10;
	c = getc(d);
      }

#ifndef BIG_ENDIAN
    if (c=='^') ungetc(c,d);

    if (swapem)
      a = a<<16 | a>>16;
#endif
    
    return a;
  }
}




FILE *prompt_file(the_prompt,mode)
char *the_prompt,*mode;
{
  char filename[80];
  FILE * workfp;
  bool success=TRUE;
  do {if (!success) (void)fprintf(stderr,"Can't open %s.\n",filename);
      (void)printf (the_prompt);
      (void)scanf ("%s", filename);
      success = ((workfp = fopen (filename, mode)) != NULL);
  } while (!success);
  return (workfp);
}



void dump_binary_world(just_new)
{
  FILE *wfp = prompt_file("Binary world file to write: ", WRITE_BINARY_MODE);
  ref *memptr;
  ref theref;
  int imod = 0;
  unsigned long worlsiz = free_point - new.start;
  unsigned DUMMY = 0;

  if (!just_new) worlsiz += spatic.size;

  putc('\002', wfp); putc('\002', wfp); putc('\002', wfp); putc('\002', wfp);

  /* Header information. */
  (void)fwrite (&DUMMY, sizeof(ref), 1, wfp);
  (void)fwrite (&DUMMY, sizeof(ref), 1, wfp);
  theref = contigify(e_boot_code);
  (void)fwrite (&theref, sizeof(ref), 1, wfp);
  (void)fwrite (&worlsiz, sizeof(ref), 1, wfp);

  /* Dump the heap. */
  /* Maybe dump spatic space. */
  if (!just_new)
    for (memptr = spatic.start; memptr < spatic.end; memptr++)
      {
	theref = *memptr;
	CONTIGIFY(theref);
	refbuf[imod++] = theref;
	if (imod == REFBUFSIZ)
	  {
	    (void)fwrite (&refbuf[0], sizeof(ref), imod, wfp);
	    imod = 0;
	  }
      }
  /* Dump new space. */
  for (memptr = new.start; memptr < free_point; memptr++)
    {
      theref = *memptr;
      CONTIGIFY(theref);
      refbuf[imod++] = theref;
      if (imod == REFBUFSIZ)
	{
	  (void)fwrite (&refbuf[0], sizeof(ref), imod, wfp);
	  imod = 0;
	}
    }
  if (imod != 0)
    (void)fwrite (&refbuf[0], sizeof(ref), imod, wfp);


  /* Weak pointer table. */
  theref = (ref)wp_index;
  (void)fwrite(&theref, sizeof(ref), 1, wfp);

  for (imod = 0; imod<wp_index; imod++)
    {
      theref = wp_table[imod];
      CONTIGIFY(theref);
      (void)fwrite(&theref, sizeof(ref), 1, wfp);
    }

  (void)fclose(wfp);
}




void dump_world(just_new)
{
  if (dump_binary)
    dump_binary_world(just_new);
  else
    {
      ref *memptr, theref;
      int i, eighter = 0;
      char *control_string
	= (dump_decimal ? control_string_dec : control_string_hex);
      FILE *wfp = prompt_file("World file to write: ", WRITE_MODE);

      (void)fprintf(wfp, control_string, 0 /*val_stk_size*/);
      (void)fprintf(wfp, control_string, 0 /*cxt_stk_size*/);
      (void)fprintf(wfp, control_string, contigify(e_boot_code));
      (void)fprintf(wfp, control_string,
		    free_point - new.start + (just_new ? 0 : spatic.size));

      /* Maybe dump spatic space. */
      if (!just_new)
	for (memptr = spatic.start; memptr < spatic.end; memptr++)
	  {
	    if (eighter == 0) (void)fprintf(wfp, "\n");
	    theref = *memptr;
	    CONTIGIFY(theref);
	    (void)fprintf(wfp,control_string, theref);
	    eighter = (eighter + 1) % 8;
	  }

      eighter = 0;
      for (memptr = new.start; memptr < free_point; memptr++)
	{
	  if (eighter == 0) (void)fprintf(wfp, "\n");
	  theref = *memptr;
	  CONTIGIFY(theref);
	  (void)fprintf(wfp,control_string, theref);
	  eighter = (eighter + 1) % 8;
	}
      (void)fprintf(wfp, "\n");

      /* Write the weak pointer table. */
     
      (void)fprintf(wfp, control_string, wp_index);
     
      eighter = 0;
     
      for (i = 0; i<wp_index; i++)
	{
	  if (eighter == 0) (void)fprintf(wfp, "\n");
	  theref = wp_table[i];
	  CONTIGIFY(theref);
	  (void)fprintf(wfp, control_string, theref);
	  eighter = (eighter + 1) % 8;
	}

      (void)fclose(wfp);
    }
}



void read_world(str)
     char *str;
{
  FILE *d = fopen(str, READ_BINARY_MODE);
  int magichar;

  if (d==NULL)
    {
      (void)printf("Can't open '%s'.\n", str);
      exit(1);
    }

  magichar = getc (d);
  if (magichar == (int)'\002')
    {
      (void)getc(d); (void)getc(d); (void)getc(d);
      input_is_binary = 1;
    }
  else
    {
      (void)ungetc(magichar, d);
      input_is_binary = 0;
#ifdef BIG_ENDIAN
      printf("Big Endian.\n");
#else
      printf("Little Endian.\n");
#endif
    }

  /* OBSOLESCENT: read val_space_size and cxt_space_size: */
  (void)read_ref(d);
  (void)read_ref(d);
  
  e_boot_code = read_ref(d);

  spatic.size = (unsigned long)read_ref(d);
  alloc_space(&spatic);

  e_boot_code += (ref)spatic.start;

  {
    unsigned long load_count;
    ref *mptr, next;

    load_count = spatic.size;
    mptr = spatic.start;
    
    if (input_is_binary)
      while (load_count != 0)
	{
	  if (nrefs_in_buf == 0)
	    {
	      nrefs_in_buf = fread (&refbuf[0], sizeof(ref), REFBUFSIZ, d);
	      next_ref_in_buf = &refbuf[0];
	    }
	  next = *next_ref_in_buf++;
	  nrefs_in_buf -= 1;
	  if ( next&2 )
	    next += (ref)spatic.start;
	  *mptr++ = next;
	  load_count -= 1;
	}
    else
      while (load_count != 0)
	{
	  next = read_ref(d);
	  if ( next&2 ) next += (ref)spatic.start;
	  *mptr++ = next;
	  --load_count;
	}
    /* Load the weak pointer table. */
    wp_index = read_ref(d);
    for (load_count=0; load_count<wp_index; load_count++)
      {
	next = read_ref(d);
	if (next&2) next += (ref)spatic.start;
	wp_table[load_count] = next;
      }
  }
  (void)fclose(d);
}





/* This is used to decode the -h option on the command line. */
long string_to_int(string)
char string[];     
{
  long n = 0;
  char *cs = string;
  while(*cs >= '0' && *cs <= '9')
    n = n*10 + *cs++ - '0';
  while (1)
    switch(*cs++)
      {
      case 'K':
      case 'k':
	n *= 1024;
	break;
      case 'M':
      case 'm':
	n *= (1024 * 1024);
	break;
      case 'W':
      case 'w':
	n *= sizeof(ref);
	break;
      case '\0':
	return(n);
      default:
	printf("Unable to parse %s as a number.\n", string);
	exit(1);
      }
}

