/* Copyright (C) 1987, Barak Pearlmutter & Kevin Lang. */

#ifdef FAST
#define DATA_PER_SEGMENT 4096	/* References stored in each segment. */
#else
#define DATA_PER_SEGMENT 64	/* References stored in each segment. */
#endif

#define HYSTERESIS	 10	/* References copied on segment creation. */

typedef struct
{
  ref type_field;
  ref length_field;
  ref previous_segment;
  ref reference_count;
  ref data[DATA_PER_SEGMENT];
} segment;

typedef struct
{
  segment *segment;		/* Current segment itself. */
  ref *bottom;			/* Lowest valid loc - 1. */
  ref *top;			/* Highest valid loc. */
  ref *ptr;			/* Pointer to top value on stack. */
  unsigned old_segments;	/* Number of pushed segments. */
} stack;

extern void init_stk();
extern void pop_segment();
extern void push_segment();
extern void pop_alot();
extern void dump_stack();
extern void gc_prepare();
extern ref peek_back_stk();
extern ref *locate_back_stk();
extern segment *allocate_segment();


/* Return the value on the top of a stack.  This can be used as an lvalue. */
#define PEEK(stk)	(*(stk).ptr)


/* Pop a thing off a stack, not putting it anywhere. */
#define POP1(stk)		\
{				\
  if (--(stk).ptr==(stk).bottom)\
    pop_segment(&(stk));	\
}


/* Pop a thing off a stack into a place. */
#define POP(stk,v)		\
{				\
  (v) = PEEK(stk);		\
  POP1(stk);			\
}



/* Push a thing onto a stack.  WARNING: this might cause a gc; if so, the value
   being pushed will NOT be properly treated.  So, this can only be called if
   the value is an immediate. */
#define PUSH_IMM(stk,v)		\
{				\
  if ((stk).top==(stk).ptr)	\
    push_segment(&(stk));	\
  *++(stk).ptr=(v);		\
}



/* Push a thing onto a stack.  This may cause a GC to occur; if so, the value
   being pushed will be properly treated. */
#define PUSH(stk,v)	\
{				\
  if ((stk).top==(stk).ptr)	\
    {				\
      GC_MEMORY(v);		\
      push_segment(&(stk));	\
      GC_RECALL(*++(stk).ptr);	\
    }				\
  else				\
    *++(stk).ptr = (v);		\
}



/* Push a thing (v) onto a stack, while making sure that if a GC happens, x,
   as well as the value, is preserved and updated.  X must be a valid rvalue
   and lvalue, and should not be side effecting. */

#define PUSH_PRESERVE1(stk,v,x)	\
{				\
  if ((stk).top==(stk).ptr)	\
    {				\
      GC_MEMORY(x);		\
      GC_MEMORY(v);		\
      push_segment(&(stk));	\
      GC_RECALL(*++(stk).ptr);	\
      GC_RECALL(x);		\
    }				\
  else				\
    *++(stk).ptr = (v);		\
}

#define PUSH_PRESERVE2(stk,v,x1,x2)	\
{				\
  if ((stk).top==(stk).ptr)	\
    {				\
      GC_MEMORY(x1);		\
      GC_MEMORY(x2);		\
      GC_MEMORY(v);		\
      push_segment(&(stk));	\
      GC_RECALL(*++(stk).ptr);	\
      GC_RECALL(x2);		\
      GC_RECALL(x1);		\
    }				\
  else				\
    *++(stk).ptr=(v);		\
}




#define stk_height(stk)						\
  ( (long)(DATA_PER_SEGMENT - HYSTERESIS) * (stk).old_segments	\
   + ((stk).ptr-(stk).bottom) )

#define bash_to_height(stk,height)				\
	pop_alot(&(stk), stk_height((stk))-(height))



#define MAKE_BACK_REF(stk,v,dist)			\
  if (((v) = (stk).ptr - (dist)) <= (stk).bottom)	\
    (v) = locate_back_stk(&(stk), (int)(dist));





#define PUSH_CONTEXT(offset)				\
{							\
  PUSH_IMM(cxt_stk,					\
	   INT_TO_REF((long)e_pc - (long)e_code_segment	\
		      + 2*(offset)));			\
  PUSH(cxt_stk, e_code_segment);			\
  PUSH(cxt_stk, PTR_TO_LOC(e_bp));			\
  PUSH(cxt_stk, PTR_TO_REF(e_env));			\
}



#define POP_CONTEXT()			\
{					\
  e_env = REF_TO_PTR(PEEK(cxt_stk));	\
  POP1(cxt_stk);			\
					\
  e_bp = LOC_TO_PTR(PEEK(cxt_stk));	\
  POP1(cxt_stk);			\
					\
  POP(cxt_stk, e_code_segment);		\
					\
  e_pc = (unsigned short *)		\
    ((long)e_code_segment		\
     + REF_TO_INT(PEEK(cxt_stk)));	\
  POP1(cxt_stk);			\
}



#define PUSHVAL(r)	PUSH(val_stk,(r))
#define PEEKVAL()	PEEK(val_stk)
#define POPVAL(r)	POP(val_stk,(r))


#define BASH_SEGMENT_TYPE(x)					\
{								\
  {								\
    segment *s = val_stk.segment;				\
    int i = val_stk.old_segments;				\
								\
    for (; i >= 0; i--,						\
	 s = (segment *)REF_TO_PTR(s->previous_segment))	\
      s->type_field = (x);					\
  }								\
  {								\
    segment *s = cxt_stk.segment;				\
    int i = cxt_stk.old_segments;				\
								\
    for (; i >= 0; i--,						\
	 s = (segment *)REF_TO_PTR(s->previous_segment))	\
      s->type_field = (x);					\
  }								\
}

