/* Copyright (C) 1987, Barak Pearlmutter & Kevin Lang. */

/* Oaklisp stacks are logically contiguous but physically
   discontiguous.  When switching segments, a little extra stuff is
   copied over to give some hysteresis, so popping and pushing across the
   boundary won't cause thrashing.  */

#include <stdio.h>
#include "emulator.h"
#include "stacks.h"


segment *allocate_segment()
{
  segment *s;
  int i;

  {
    ref *p;

    ALLOCATE(p, sizeof(segment)/sizeof(ref),
	     "space crunch in allocate_segment()");
    s = (segment *)p;
  }

  s->type_field = e_segment_type;
  s->length_field = INT_TO_REF(sizeof(segment)/sizeof(ref));
  s->reference_count = INT_TO_REF(0);
  for (i=0; i<DATA_PER_SEGMENT; i++)
    s->data[i] = INT_TO_REF(0);
  
  return s;
}


void init_stk(pstk)
     stack *pstk;
{
  pstk->old_segments = 0;
  pstk->segment = allocate_segment();
  pstk->segment->previous_segment = INT_TO_REF(0);
  pstk->bottom = &pstk->segment->data[-1];
  pstk->top = &pstk->segment->data[DATA_PER_SEGMENT-1];
  pstk->ptr = &pstk->segment->data[0];
  *pstk->ptr = INT_TO_REF(1234);
}


void pop_segment(pstk)
     stack *pstk;
{
  if (pstk->ptr == pstk->bottom)
    {
      /* We just ran off the bottom of the segment. */

#ifndef FAST
      if (trace_segs) printf("p");
#endif
      pstk->segment = (segment *)REF_TO_PTR(pstk->segment->previous_segment);
      pstk->bottom = &pstk->segment->data[-1];
      pstk->top = &pstk->segment->data[DATA_PER_SEGMENT - 1];
      pstk->ptr = &pstk->segment->data[DATA_PER_SEGMENT - HYSTERESIS - 1];
      pstk->old_segments -= 1;
    }
  else
    printf("Warning: pop_segment() called when ->ptr != ->bottom; ignored.\n");
}



void push_segment(pstk)
     stack *pstk;
{
  if (pstk->top == pstk->ptr)
    {
      /* We just ran off the top of the segment.
	 Watch it; this allocation may cause a GC. */
      segment *new_segment = allocate_segment();
      segment *old_segment = pstk->segment;
      int i;

#ifndef FAST
      if (trace_segs) printf("P");
#endif
      new_segment->previous_segment = PTR_TO_REF(old_segment);
      for (i=0; i<HYSTERESIS; i++)
	{
	  new_segment->data[i] =
	    old_segment->data[DATA_PER_SEGMENT - HYSTERESIS + i];
	  /*
	  old_segment->data[DATA_PER_SEGMENT-HYSTERESIS+i] = INT_TO_REF(0);
	  */
	}

      pstk->segment = new_segment;
      pstk->bottom = &new_segment->data[-1];
      pstk->top = &new_segment->data[DATA_PER_SEGMENT-1];
      pstk->ptr = &new_segment->data[HYSTERESIS-1];
      pstk->old_segments += 1;
    }
  else
    printf("Warning: push_segment called with pstk->ptr != pstk->top.\n");
}







void pop_alot(pstk, amount)
     stack *pstk;
     long amount;
{
  ref *p1 = pstk->ptr - amount;

  while (p1 <= pstk->bottom)
    {
      amount -= pstk->ptr - pstk->bottom;
      pstk->ptr = pstk->bottom;
      pop_segment(pstk);
      p1 = pstk->ptr - amount;
    }

  pstk->ptr = p1;
}





ref peek_back_stk(pstk, dist)
     stack *pstk;
     int dist;
{
  ref *bottom = pstk->bottom;
  ref *ptr = pstk->ptr;
  ref *p = ptr - dist;

#ifndef FAST
  if (trace_segs) printf("l");
#endif
  if (p <= bottom)
    {
      segment *s = pstk->segment;
      
      do
	{
#ifndef FAST
      if (trace_segs) printf("L");
#endif
	  dist -= ptr - bottom;
	  s = (segment *)REF_TO_PTR(s->previous_segment);
	  ptr = &s->data[DATA_PER_SEGMENT - HYSTERESIS - 1];
	  p = ptr - dist;
	  bottom = &s->data[-1];
	} while (p <= bottom);
    }
  
  return *p;
}
/*
{
  if (dist < pstk->ptr - pstk->bottom)
    return *(pstk->ptr - dist);

  {
    segment *the_segment
      = (segment *)REF_TO_PTR(pstk->segment->previous_segment);

#ifndef FAST
      if (trace_segs) printf("l");
#endif
    dist -= pstk->ptr - pstk->bottom;

    while (dist >= DATA_PER_SEGMENT-HYSTERESIS)
      {
#ifndef FAST
	if (trace_segs) printf("L");
#endif
	the_segment = (segment *)REF_TO_PTR(the_segment->previous_segment);
	dist -= DATA_PER_SEGMENT-HYSTERESIS;
      }

    return the_segment->data[DATA_PER_SEGMENT - HYSTERESIS - 1 - dist];
  }
}
*/




ref *locate_back_stk(pstk, dist)
     stack *pstk;
     int dist;
{
  ref *bottom = pstk->bottom;
  ref *ptr = pstk->ptr;
  ref *p = ptr - dist;

#ifndef FAST
  if (trace_segs) printf("l");
#endif
  if (p <= bottom)
    {
      segment *s = pstk->segment;
      
      do
	{
#ifndef FAST
  if (trace_segs) printf("L");
#endif
	  dist -= ptr - bottom;
	  s = (segment *)REF_TO_PTR(s->previous_segment);
	  ptr = &s->data[DATA_PER_SEGMENT - HYSTERESIS - 1];
	  p = ptr - dist;
	  bottom = &s->data[-1];
	} while (p <= bottom);
    }
  
  return p;
}
/*
{
  if (dist < pstk->ptr - pstk->bottom)
    return pstk->ptr - dist;

  {
    segment *the_segment
      = (segment *)REF_TO_PTR(pstk->segment->previous_segment);

#ifndef FAST
    if (trace_segs) printf("l");
#endif
    dist -= pstk->ptr - pstk->bottom;

    while (dist >= DATA_PER_SEGMENT-HYSTERESIS)
      {
#ifndef FAST
	if (trace_segs) printf("L");
#endif
	the_segment = (segment *)REF_TO_PTR(the_segment->previous_segment);
	dist -= DATA_PER_SEGMENT-HYSTERESIS;
      }

    return &the_segment->data[DATA_PER_SEGMENT - HYSTERESIS - 1 - dist];
  }
}
*/



void dump_stack(pstk)
     stack *pstk;
{
  int i = stk_height(*pstk);
#ifndef FAST
  bool real_trace_segs = trace_segs;

  trace_segs = 0;
#endif

  (void)printf("stack contents (%d): ", i);
  while (i-- > 0)
    {
      printref(peek_back_stk(pstk, i));
      (void)putc( i>0 ? ' ' : '\n', stdout);
    }

#ifndef FAST
  trace_segs = real_trace_segs;
#endif
  (void)fflush(stdout);
}




/* This routine zeros out all unused slots in the stack segment, thus allowing
   the garbage collector to potentially collect them. */
void gc_prepare(pstk)
     stack *pstk;
{
  ref *p;

  for (p = pstk->ptr + 1; p <= pstk->top; p++)
    *p = INT_TO_REF(0);
}
