/*  Copyright (C) 1987 Barak Pearlmutter and Kevin Lang    */

#include <stdio.h>
#include "emulator.h"




void free_space(pspace)
     space *pspace;
{
#ifdef UNALIGNED
  free((char *)pspace->start + pspace->offset);
  if (space->offset)
    pspace->size += 1;
#else
  free((char *)pspace->start);
#endif

  pspace->start = pspace->end = NULL;
}




void alloc_space(pspace)
     space *pspace;
{
  char *p = malloc(sizeof(ref) * pspace->size);

  if (p == NULL)
    {
      (void)fprintf(stderr,
		    "\nUnable to allocate %ld references.\n", pspace->size);
      exit(1);
    }

#ifdef UNALIGNED
  pspace->offset = (long)p & 3;
  p = (char *) ((long)p & ~3);
  if (pspace->offset)
    pspace->size -= 1;
#endif

  pspace->start = (ref *) p;
  pspace->end = pspace->start + pspace->size;
}



      
  

char *my_malloc(i)
     unsigned i;
{
  char *p = malloc(i);

  if (p == NULL)
    {
      (void)fprintf(stderr, "\nUnable to allocate %d bytes.\n", i);
      exit(1);
    }

  return p;
}
