/*  Copyright (C) 1987 Barak Pearlmutter and Kevin Lang    */

#include "config.h"


extern char *malloc();


#define DEFAULT_NEW_SPACE_SIZE (128 * 1024) /* measured in references */

#define READ_MODE "r"
#define WRITE_MODE "w"
#define APPEND_MODE "a"

#ifdef Mac

#define READ_BINARY_MODE "r+b"
#define WRITE_BINARY_MODE "w+b"

#else

#define READ_BINARY_MODE READ_MODE
#define WRITE_BINARY_MODE WRITE_MODE

#endif




#ifndef NULL
#define NULL 0L
#endif


typedef int bool;

#define FALSE 0
#define TRUE 1



typedef unsigned long int ref;


#define TAG_MASK	3
#define SUBTAG_MASK	0xFF

#define INT_TAG		0
#define IMM_TAG		1
#define LOC_TAG 	2
#define PTR_TAG		3

#define PTR_MASK	2

#define CHAR_SUBTAG	((0*4)+IMM_TAG)
#define WP_SUBTAG	((1*4)+IMM_TAG)

#define TAG_IS(X,TAG)		(((X)&TAG_MASK)==(TAG))
#define SUBTAG_IS(X,SUBTAG)	(((X)&SUBTAG_MASK)==(SUBTAG))

#define INT_TO_REF(i)	((ref)((i)<<2))
#define REF_TO_INT(r)	ASHR2((long)(r))

#define REF_TO_PTR(r)	((ref *)((r)-PTR_TAG))
#define LOC_TO_PTR(r)	((ref *)((r)-LOC_TAG))

#define ANY_TO_PTR(r)	((ref *)((r)&~TAG_MASK))


#define PTR_TO_LOC(p)	((ref)((ref)(p) | LOC_TAG))
#define PTR_TO_REF(p)	((ref)((ref)(p) | PTR_TAG))
/* #define PTR_TO_LOC(p)	((ref)(p)+LOC_TAG)
   #define PTR_TO_REF(p)	((ref)(p)+PTR_TAG) */

#define REF_TO_CHAR(r)	((char)(((r)&1)?((r)/256):ASHR2(r)))

#define CHAR_TO_REF(r)	(((r)<<8)|CHAR_SUBTAG)


#ifdef ibmrt	/* expand this to include any system with unsigned chars */
#define SIGN_8BIT_ARG(c)	(((c) & 0x80) ? ((c) | 0xffffff80) : (c))
#else
#define SIGN_8BIT_ARG(x)	((char)(x))
#endif

#define SIGN_16BIT_ARG(x)	((short)(x))

/* The following can be ((x)>>2) on machines with arithmetic right shifts. */
#define ASHR2(x) ((x)/4)


/*
 * Offsets for wired types.  Offset includes type and
 * optional length fields when present.
 */

/* CONS-PAIR: */
#define CONS_PAIR_CAR_OFF	1
#define CONS_PAIR_CDR_OFF	2

/* TYPE: */
#define TYPE_LEN_OFF		1
#define TYPE_VAR_LEN_P_OFF	2
#define TYPE_SUPER_LIST_OFF	3
#define TYPE_IVAR_LIST_OFF	4
#define TYPE_IVAR_COUNT_OFF	5
#define TYPE_TYPE_BP_ALIST_OFF	6
#define TYPE_OP_METHOD_ALIST_OFF 7
#define TYPE_WIRED_P_OFF	8

/* METHOD: */
#define METHOD_CODE_OFF		1
#define METHOD_ENV_OFF		2

/* CODE-VECTOR: */
#define CODE_IVAR_MAP_OFF	2
#define CODE_CODE_START_OFF	3

/* OPERATION: */
#define OPERATION_LAMBDA_OFF		1
#define OPERATION_CACHE_TYPE_OFF	2
#define OPERATION_CACHE_METH_OFF	3
#define OPERATION_CACHE_TYPE_OFF_OFF	4

/* ESCAPE-OBJECT */
#define ESCAPE_OBJECT_VAL_OFF	1
#define ESCAPE_OBJECT_CXT_OFF	2

/* Continuation Objects */
#define CONTINUATION_VAL_SEGS	1
#define CONTINUATION_VAL_OFF	2
#define CONTINUATION_CXT_SEGS	3
#define CONTINUATION_CXT_OFF	4

#define car(x)	(REF_SLOT((x),CONS_PAIR_CAR_OFF))
#define cdr(x)	(REF_SLOT((x),CONS_PAIR_CDR_OFF))


extern void free_space(), alloc_space();
extern char *my_malloc();


extern ref e_t, e_nil, e_fixnum_type, e_loc_type, e_cons_type,
  *e_subtype_table, *e_bp, *e_env, e_env_type, *e_argless_tag_trap_table,
  *e_arged_tag_trap_table, e_object_type, e_segment_type, e_code_segment,
  e_boot_code, e_current_method;

extern unsigned short *e_pc;


extern void printref();

extern bool trace_segs;

extern bool dump_decimal, dump_binary;


extern void read_world();
extern ref read_ref();
extern void dump_world();



extern long string_to_int();



extern unsigned long get_length();



typedef struct
{
  ref *start, *end;
  long size;
#ifdef UNALIGNED
  char offset;
#endif
} space;

extern space spatic, new;
extern ref *free_point;


#define SPACE_PTR(s,p)	((s).start<=(p) && (p)<(s).end)

#define NEW_PTR(r)	SPACE_PTR(new,(r))
#define SPATIC_PTR(r)	SPACE_PTR(spatic,(r))


#define wp_to_ref(r)	(wp_table[(r)>>8])
extern ref wp_table[];
extern long wp_index;
extern ref ref_to_wp();
#define INT_TO_WP(i)	((ref)((i<<8)|WP_SUBTAG))
extern void gc();
extern void gc_panic();
extern void gc_printref();

extern ref *gc_examine_ptr;
#define GC_MEMORY(v) {*gc_examine_ptr++ = (v);}
#define GC_RECALL(v) {(v) = *--gc_examine_ptr;}


/* This is used to allocate some storage.  It calls gc when necessary. */

#define ALLOCATE(p, words, place)			\
  ALLOCATE_PROT(p, words, place, , )

/* This is used to allocate some storage, if the stack pointers have not been
   backed into the structures, and hence must be before gc. */

#define ALLOCATE_SS(p, words, place)			\
  ALLOCATE_PROT(p, words, place,			\
		{ UNOPTC(cxt_stk.ptr = cxt_stk_ptr);	\
		  UNOPTV(val_stk.ptr = val_stk_ptr); },	\
		{ UNOPTV(val_stk_ptr = val_stk.ptr);	\
		  UNOPTC(cxt_stk_ptr = cxt_stk.ptr); })

/* This allocates some storange, assumeing the stack pointers have not been
   backed into the structures and that v must be protected from gc. */

#define ALLOCATE1(p, words, place, v)			\
  ALLOCATE_PROT(p, words, place,			\
		{ GC_MEMORY(v);				\
		  UNOPTC(cxt_stk.ptr = cxt_stk_ptr);	\
		  UNOPTV(val_stk.ptr = val_stk_ptr); },	\
		{ UNOPTV(val_stk_ptr = val_stk.ptr);	\
		  UNOPTC(cxt_stk_ptr = cxt_stk.ptr);	\
		  GC_RECALL(v); })

#define ALLOCATE_PROT(p, words, place, before, after)	\
  /* ref *p; int words; string place; */		\
{							\
  ref *new_free_point = free_point + (words);		\
							\
  if (new_free_point >= new.end)			\
    {							\
      before;						\
      gc(0, (place));					\
      after;						\
      new_free_point = free_point + (words);		\
      if (new_free_point >= new.end)			\
	gc_panic((place));				\
    }							\
							\
  (p) = free_point;					\
  free_point = new_free_point;				\
}



/* These gets slots out of Oaklisp objects, and may be used as lvalues. */
#define SLOT(p,s)	(*((p)+(s)))
/* #define REF_SLOT(r,s)	SLOT(REF_TO_PTR(r),s) */
#define REF_SLOT(r,s) (*(ref *)((r)-3+sizeof(ref)*(s)))


#define MIN_REF ((ref)(0x80000000L))
  /* INT_TO_REF(0x20000000) */
  /* ((ref)(MININT&~3|INT_TAG)) */



/* eof */
