/*  Copyright (C) 1987 Barak Pearlmutter and Kevin Lang    */

/*
 * This file describes the configuration of the machine that is being
 * compiled on.  It deals with quirks of the CPU and OS.
 */


/* Try to figure out the endianity.  This doesn't really work.  */

#if ('A\0' == 0x41)
#ifndef vax /* cpp on a vax thinks big endian! */
#define BIG_ENDIAN
#endif /* vax */
#endif



/* UNALIGNED should be defined if malloc() might return a pointer that isn't
   long aligned, ie, whose low two bits might not be 0. */

#ifdef mac
#define UNALIGNED
#endif




/* MAXINT and MININT are the same on all 32 bit twos complement machines. */

#define MAXINT (0x7fffffff)
#define MININT (-MAXINT-1)




/* Detecting overflow efficiently is very important, and can not be
   expressed portably and efficiently in C.  The construct OVERFLOW
   should be defined to do a branch to the given label if there was no
   overflow in the last operation, or an if statement with the given
   test, if there is no way to test the overflow condition code.

   Obviously, this is CPU and compiler dependent.  */

/* For now, we don't really do the test.  The code below is believed
   to work for VAXes under pcc and tcc, and in the default case, of
   course.  It doesn't work on a Sun, even with the target (z) in a
   register, because the computation happens to d0 and then d0 is moved
   to z, which clears the overflow flag.  Yum.  Also, the compiler on a
   Sun sees the code following the OVERFLOW() as dead, not noticing the
   label.  */

#define OVERFLOW(label,test,trap) {}

#ifdef COMMENTOUT


#ifdef vax

#define OVERFLOW(label,test,trap)	\
{					\
  asm("	bvc	label");		\
  {trap;}				\
  asm("label:");			\
}

#else
#ifdef mc68000

/* Because of the somewhat riscy nature of the 68000, z had darn well better
   be in a register. */
#define OVERFLOW(label,test,trap)	\
{					\
  asm("	bvcs	label");		\
  {trap;}				\
  asm("label:");			\
}

#else

#define OVERFLOW(label,test,trap) {if (test) {trap};}

#endif /* def mc68000 */
#endif /* def vax */


#endif /* def COMMENTOUT */



/* eof */
