/* -*-C-*-

Copyright (c) 1987 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. */

/* $Header: cmp68kgc.h,v 9.26 87/07/30 14:59:31 GMT jinx Rel $

Utilities to relocate compiled code in garbage collection-like processes. 

This file is conditionally included by gccode.h.
*/

/* The following is a kludge which is used to get
   return_to_interpreter and uuo_link_trap to work.
   The return to interpreter block is never dumped on normal
   bin files, but is dumped in complete bands.
   As long as it does not change in position with respect to the
   beginning of constant space, it will be relocated correctly on
   reload.
 */

#ifndef In_Fasdump

#define Compiled_Code_Pre_Test(then_what)

#else

extern Pointer compiler_utilities;

#define Compiled_Code_Pre_Test(then_what)				\
if (Old == Get_Pointer(compiler_utilities))				\
  then_what;								\
else

#endif

/* The following code handles compiled entry points, where the addresses
   point to the "middle" of the code vector.  The word before the one
   pointed at contains an offset to the beginning of the block so it
   can be found and copied as a whole.  The broken heart for the whole
   block lives in its usual place (first word in the vector).
   If the offset is odd, then it actually points to another offset.
 */

#define Get_Compiled_Block_Step(var, address)				\
{									\
  var = ((Pointer *) (((char *) (address)) -				\
		      ((unsigned long)					\
		       (((unsigned short *) (address))[-1]))));		\
}

#define Get_Compiled_Block(var, address)				\
{									\
  Get_Compiled_Block_Step(var, address);				\
  while (((unsigned long) var) & 1)					\
  {									\
    var = ((Pointer *) (((char *) (var)) + 1));				\
    Get_Compiled_Block_Step(var, var);					\
  }									\
}

/* Pointers to char are used here because compiled entry points do not
   in general point to Pointer boundaries.
 */

#define Relocate_Compiled(object, new_block, old_block)			\
Make_Pointer(Type_Code(object),						\
	     ((Pointer *) (((char *) new_block) +			\
			   (((char *) Get_Pointer(object)) -		\
			    ((char *) old_block)))))

#define Compiled_BH(In_GC, then_what)					\
{									\
  /* Has it already been relocated? */					\
									\
  Get_Compiled_Block(Old, Old);						\
  Compiled_Code_Pre_Test(then_what)					\
  if (Type_Code(*Old) == TC_BROKEN_HEART)				\
  {									\
    *Scan = Relocate_Compiled(Temp, Get_Pointer(*Old), Old);		\
    then_what;								\
  }									\
}

#define Transport_Compiled()						\
{									\
  Pointer *Saved_Old = Old;						\
									\
  Real_Transport_Vector();						\
  *Saved_Old = New_Address;						\
  *Scan = Relocate_Compiled(Temp,					\
			    Get_Pointer(New_Address),			\
			    Saved_Old);					\
}
