;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

(declare (usual-integrations))
(declare (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/typical/kernel"))

(define (get-type-methods object method-property)
  (let ((handlers ()))
    (define (check-type-for-handler type)
      (let ((handler (methods-property type)))
	(if (defined? handler)
	    (set! handlers (cons handler handlers)))))
    (maptypes check-type-for-handler object)
    (reverse handlers)))

(define (method-combiner methods)
  (define (method-combination x)
    (define (try-methods method-list)
      (if (null? method-list) (%undefined)
	  (let ((attempt ((first method-list) x)))
	    (if (defined? attempt) attempt
		(try-methods (rest method-list)))))))
  method-combination)

(define (combine-methods object instance-methods-property type-method-property)
  (let ((instance-methods (instance-method-property object))
	(type-methods (get-type-handlers object type-method-property)))
    (method-combiner
     (if (defined? instance-methods)
	 (append instance-methods type-methods) type-methods))))

(define (define-method! type method-property method)
  ((modifier method-property) type method))
