/* %W% %G% */

#ifndef _STUFF_H_
#define _STUFF_H_

#include "config.h"

	/* generic pointer type */
#if defined( __STDC__) || defined(sun)

typedef void *Ptr;

#else

#ifdef sequent
typedef long Ptr;
#else
typedef char *Ptr;
#endif /* sequent */

#endif /* defined(__STDC__) || defined(sun) */

#ifndef TRUE
#define TRUE 1
#endif /* TRUE */
#ifndef FALSE
#define FALSE 0
#endif /* FALSE */

typedef int	Boolean;
typedef int	(*F_INT)();
typedef char	*(*F_STR)();
typedef Boolean	(*F_BOOLEAN)();
typedef void	(*F_VOID)();
typedef Ptr	(*F_PTR)();

extern char *Mymalloc();
extern char *Mycalloc();
extern char *strcopy();

extern void mallocError();

/* NEW, NEWVEC, and NEWLOCVEC from P. Hilfinger */

/* Return an allocated pointer to type. */
#define NEW(type) ((type *)Mymalloc((unsigned)sizeof(type)))

/* Return an array of n type objects. */
#define NEWVEC(type,n) ((type *)Mycalloc((unsigned)(n),(unsigned)sizeof(type)))

#if defined(NOALLOCA) || defined(__SABER__)

/* Temporary array of n type objects. */
#define NEWLOCVEC(type,length) NEWVEC(type,length)
#define FREELOCVEC(vec) (void)free((char *)vec)

#else

/* Temporary array of n type objects. */
#define NEWLOCVEC(type,length) ((type *) alloca(sizeof(type)*(length)))
#define FREELOCVEC(vec)

#endif /* defined(NOALLOCA) || defined(__SABER__) */

/* assertion checking */

#ifdef DEBUG
#ifdef __STDC__
#define ASSERT(condition) \
    if (!(condition)) { \
	(void)fprintf(stderr, \
		      "Assertion (%s) failed\n\tat line %d of file %s\n", \
		      #condition, __LINE__, __FILE__); \
	abort(); \
    }
#else
#define ASSERT(condition) \
    if (!(condition)) { \
	(void)fprintf(stderr, "Assertion failed at line %d of file %s\n", \
		      __LINE__, __FILE__); \
	abort(); \
    }
#endif /* defined(__STDC__) */

#else
#define ASSERT(condition)
#endif /* defined(DEBUG) */

/* bit mask for bit position x */
#define BIT(x) (1<<(x))

#endif /* !defined(_STUFF_H_) */
