/* @(#)opcodes.i	1.5 2/12/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

/* OPCODE(name, number of operands) */

/* format of opcode: x1 ... xn code(y1, ... yn) where the xx's are the
 * args (on the stack) and the yy's are operands (in the code). */

/* Access local variable and push value on the stack.
 * code_local(offset) */
OPCODE(code_local, 1)

/* Access local variable from enclosing scope and push value on the stack.
 * code_access(links, offset) */
OPCODE(code_access, 2)

/* Access non-local variable and push value on the stack.
 * code_unbind(binding) */
OPCODE(code_unbind, 1)

/* push obj onto stack and link
 * code_push(obj) */
OPCODE(code_push, 1)

/* pop obj from stack and unlink
 * obj code_pop() */
OPCODE(code_pop, 0)

/* Call procedure with tail recursion if possible.  When proc is not
 * the same as codeProc, this call executes exactly like code_call.
 * Otherwise, codeFrame is updated with args.  codeVec is set to
 * the beginning of proc.
 * arg0 ... argn proc code_tail_call(n)
 */
OPCODE(code_tail_call, 1)

/* Call procedure.  If proc is a user procedure, a new frame is
 * created and the args are placed in it.  The original codeProc,
 * codeVec, and codeFrame are pushed on the stack and set to the
 * appropriate values for proc. Otherwise, the C function of proc
 * is called with the address of the first arg.
 * arg1 ... argn proc code_call(n) */
OPCODE(code_call, 1)

/* Return from user call.  Restore codeProc, codeVec, and codeFrame.
 * Leaves result on the stack.
 * codeProc codeVec codeFrame result code_call_return() */
OPCODE(code_call_return, 0)

/* branch to codeVec + offset
 * code_goto(offset) */
OPCODE(code_goto, 1)

/* branch to codeVec + offset if pred is nil
 * pred code_branch(offset) */
OPCODE(code_branch, 1)

/* branch to codeVec + offset if pred is nil, leaving pred on the stack
 * pred code_branch_save(offset) */
OPCODE(code_branch_save, 1)

/* branch to codeVec + offset if pred is not nil, leaving pred on the stack
 * pred code_tbranch_save(offset) */
OPCODE(code_tbranch_save, 1)

/* Call c function with an array of arguments, the number of args, and
 * the current frame; the result is pushed on the stack.
 * arg1 ... argn code_cfunc(cfunc, n) */
OPCODE(code_cfunc, 2)

/* Like code_cfunc except an array of operands from the codevector is
 * passed which can contain arbitrary data.
 * arg1 ... argn code_cfuncN(cfunc, n, N) op1 .. opN */
OPCODE(code_cfuncN, 3)

/* call-with-current-continuation
 * proc code_call_cc() */
OPCODE(code_call_cc, 0)

/* apply procedure to argument list
 * proc arglist code_apply() */
OPCODE(code_apply, 0)

/* tail-recursively apply procedure to argument list 
 * proc arglist code_tail_apply() */
OPCODE(code_tail_apply, 0)

/* replace the fixed vector with args from the stack
 * arg1 ... argn code_replace(n) */
OPCODE(code_replace, 1)

/* halt execution
 * code_halt() */
OPCODE(code_halt, 0)

#undef OPCODE
