/* %W% %G% */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#include "fools.h"
#include "utils.h"

/* Prompt for input if InteractiveMode is set */
static Boolean InteractiveMode = TRUE;

/* Put ac and av into the user environment as *argc* and *argv*. */
static void buildArglist(ac, av)
     int ac;
     char **av;
{
    Obj argv;

    argv = NilSymb;
    av += ac;
    objPut(objIntern("*argc*", STATIC),
	   newInteger(gcNew, (long)ac), GlobalEnv);
    while (--ac >= 0)
	argv = newPair(gcNew, newString(gcNew, *(--av)), argv);
    objPut(objIntern("*argv*", STATIC), argv, GlobalEnv);
}

static char *help_mesg[] = {
    "\t-s script [ arg ... ]\texecute script\n",
    "\t-v script [ arg ... ]\texecute script and print results\n",
    "\t[ file [ file ... ] ]\tload each file\n",
};

static void parseArgs(ac, av)
     int ac;
     char *av[];
{
    int i;
    char *ptr;
    Boolean noisy = FALSE;

    for (i = 1; i < ac; i++) {
	if (*av[i] == '-') {
	    switch (av[i][1]) {
	    case 'q':
		InteractiveMode = FALSE;
		break ;
	    case 'n':
		noisy = TRUE;
		break ;

	    case 'v':
		noisy = TRUE;
	    case 's':
		if (i != 1) {
		    (void)fprintf(stderr, "-%c must be the first option\n",
				  av[i][1]);
		    exit(1);
		}
		    
		if (++i >= ac) {
		    (void)fprintf(stderr, "missing script\n");
		    exit(1);
		}
		buildArglist(ac - i, &av[i]);
		loadFile(av[i], TRUE, noisy, TRUE);
		return ;
	    case 'd':
#ifdef DEBUG
		ptr = &av[i][2];
		while (*ptr) {
		    switch (*ptr++) {
		    case 't':
			debugTrace = 1;
			break ;
		    case 'g':
			debugGC = 1;
			break ;
		    case 'd':
			debugDestroy = 1;
			break ;
		    case 'm':
			debugMacro = 1;
			break ;
		    case 'c':
			debugCode = 1;
			break ;
		    case 'k':
			debugCont = 1;
		    }
		}
#endif /* DEBUG */
		break ;

	    default:
		for (i = 0; i < sizeof (help_mesg) / sizeof (*help_mesg); i++)
		    (void)fputs(help_mesg[i], stderr);
		exit(1);
	    }
	}
	else  loadFile(av[i], FALSE, noisy, TRUE);
    }
}

extern char Version[], Date[];
extern void foolsInit(), codeInit(), parseInit(), packageInit();

Boolean
protectFunc(func, intp)
     F_VOID func;
     Boolean intp;
{
    jmp_buf errmark;

    errorSetLevel(errmark);
    if (setjmp(errmark) == 0) {
	gcBegin();

	if (intp) intEnable();
	(*func)();
	if (intp) intDisable();

	gcEnd();
    }
    else {
	/* error */
	errorClearLevel();
	return FALSE;
    }
    return TRUE;
}

main(argc, argv)
     int argc;
     char *argv[];
{
    FILE *out;
#ifdef DEBUG
    extern void opcodeCount();
#endif /* DEBUG */

    listInit(1024);
    treeInit(1024);
    gcInit();
    errorInit();
    parseInit();
    codeInit();
    globalsInit();
    packageInit();

    foolsInit();

    parseArgs(argc, argv);

    out = stdout;
    if (InteractiveMode)
	(void)printf("%s %s\n", Version, Date);
    else out = (FILE *)NULL;

    do {
	repLoop(InFile, out, InteractiveMode);
	fileReset(InFile);
    } while (errorFlag != NoInput);

#ifdef DEBUG
    if (debugTrace) opcodeCount();
#endif /* DEBUG */

    return 0;
}
