/* @(#)Special.h	1.5 4/23/90 */

/* unique objects (true, false, empty list) */

typedef struct uniqueInst_s {
    basicInst_t inherit;
    char *pname;
} uniqueInst_t, *uniqueInst;

extern basicClass_t protoNil, protoTrue, protoFalse, protoEOF;

#define NilClass ((Class)&protoNil)
#define TrueClass ((Class)&protoTrue)
#define FalseClass ((Class)&protoFalse)
#define EOFClass ((Class)&protoEOF)

/* package specifiers */

typedef struct packageInst_s {
    basicInst_t inherit;
    Obj sym, package; /* symbol and defining package */
} packageInst_t, *packageInst;

extern basicClass_t protoPackage;
#define Package ((Class)&protoPackage)

/* boxes */

typedef struct boxInst_s {
    basicInst_t inherit;
    Obj ref; /* box is a reference to */
} boxInst_t, *boxInst;

extern basicClass_t protoBox;
#define Box ((Class)&protoBox)

#ifdef __STDC__

/* Create the unique object for class.  pname is the print name
 *
 * This should only be called once to instantiate the unique object. */
extern Obj newUnique(Class class, char *pname);

/* Convert pspec (= package-name:symbol) into a packaged-symbol */
extern Obj newPackage(char *pspec);

/* Get the binding (package . environment) for the symbol package. */
extern Obj packageByName(Obj name);

/* make a new box (pointer type) */
extern Obj newBox(F_OBJ alloc, Obj ref);

/* change reference of box to ref */
extern void objBoxSet(Obj box, Obj ref);

#else

extern Obj newUnique();
extern Obj newPackage();
extern Obj packageByName();
extern Obj newBox();
extern void objBoxSet();

#endif /* __STDC__ */
