/* @(#)Basic.h	1.7 1/16/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#ifndef _BASIC_H
#define _BASIC_H

/* basic types, accessors, and procedures for objects */

/* get item in obj whose class is type */
#define DATA(obj, item, type) (((type)(obj))->item)

/* class of obj */
#define TCLASS(obj, type) ((type)DATA((obj), class, basicInst))
#define CLASS(obj) TCLASS((obj), Class)

/* super class of obj */
#define SUPER(obj) (((basicClass)DATA((obj), class, basicInst))->super)

/* call procedure proc of obj whose class is type */
#define PROC(obj, proc, type) (*(TCLASS((obj), type)->proc))

/* status checking */
#define checkCond(st, c) (DATA((st), status, basicInst) & (c))
#define setCond(st, c) (DATA((st), status, basicInst) |= c)
#define clearCond(st, c) (DATA((st), status, basicInst) &= ~(c))

/* global status flags (top eight bits) */
#define MARK	BIT(9)	/* mark bit for objects */
#define ZAP	BIT(8)	/* object contains malloc'ed data */

/* generic Class and Obj types */
typedef struct basicClass_s *Class;
typedef struct basicInst_s *Obj;

typedef Obj (*F_OBJ)();

/* basic class */
typedef struct basicClass_s {
    Class super;	/* pointer to the superclass */
    int size;		/* size of instance */
    F_VOID print;	/* printer */
    F_VOID destroy;	/* destructor */
    char *type;		/* string representing object type */
    Obj typesym;	/* type symbol (initially null) */
} basicClass_t, *basicClass;

#define DEFBASIC(class, size, print, destroy, type) \
	{(Class)class, sizeof (size), print, destroy, type, (Obj)NULL}

/* basic instance */
typedef struct basicInst_s {
    Class class; /* initial class */
    short status; /* misc. flags */
    short rc; /* reference count */
} basicInst_t, *basicInst;

extern basicClass_t protoBasic;
#define Basic ((Class)&protoBasic)

/* macro versions of link and unlink */

/* lambda reference counts are also passed to its the defining frame */
#define LINK(OBJ)\
{\
    ++DATA((OBJ), rc, basicInst);\
    if (CLASS((OBJ)) == User)\
	++DATA(DATA((OBJ), frame, userInst), rc, basicInst);\
}

/* when unlinking a lambda the defining frame is also unlinked except
 * in the case where the lambda is to be destroyed and it is bound
 * within its defining frame */
#define UNLINK(OBJ)\
{\
    register Obj _fr;\
    if (--DATA((OBJ), rc, basicInst) == 0) {\
	if (CLASS((OBJ)) == User && !checkCond((OBJ), INTERNAL)) {\
	    _fr = DATA((OBJ), frame, userInst);\
	    if (--DATA(_fr, rc, basicInst) == 0) objDestroy(_fr);\
	}\
	objDestroy((OBJ));\
    }\
    else if (CLASS((OBJ)) == User) {\
	_fr = DATA((OBJ), frame, userInst);\
	if (--DATA(_fr, rc, basicInst) == 0) objDestroy(_fr);\
    }\
}

#ifdef INLINE

/* inline objLink and objUnlink */
#define objLink(OBJ) { register Obj _obj = (OBJ); LINK(_obj); }
#define objUnlink(OBJ) { register Obj _obj = (OBJ); UNLINK(_obj); }

#else

#define objLink(OBJ) _objLink(OBJ)
#define objUnlink(OBJ) _objUnlink(OBJ)

#endif /* defined(INLINE) */

#ifdef __STDC__

/* basic procedures */

/* send print representation of obj to stream file */
extern void objPrint(Obj obj, FILE *file);

/* free memory and resources held by obj */
extern void objDestroy(Obj obj);

/* increment obj's reference count */
extern void _objLink(Obj obj);

/* decrement reference count of obj and destroy if count is zero */
extern void _objUnlink(Obj obj);

/* get the type symbol of obj */
extern Obj objType(Obj obj);

/* get the type symbol of class */
extern Obj typeSym(Class class);

/* TRUE if obj is of type class or a subtype of class. */
extern Boolean objIsClass(Obj obj, Class class);

#else

extern void objPrint();
extern void objDestroy();

extern void _objLink();
extern void _objUnlink();
extern Obj objType();
extern Obj typeSym();
extern Boolean objIsClass();

#endif /* defined(__STDC__) */

#endif /* !defined(_BASIC_H) */
