;;; -*- Mode:Scheme; Base:10 -*- PS9-GRAF.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			     Fall Semester, 1992
;;
;;				 Problem Set 9

;;; Graphics window hackery for reg mach simulator stack monitoring

(define *graphics-window* false)

(define (clear-graphics)
  (cond (*graphics-window*
	 (graphics-clear *graphics-window*))))

(define (disable-stack-graphics)
  (set! *regsim-stack-graphics?* false)
  (cond (*graphics-window*
	 (graphics-close *graphics-window*)))
  (set! *graphics-window* false)
  'stack-graphics-disabled)

(define (enable-stack-graphics)
  (set! *regsim-stack-graphics?* true)
  (initialize-graphics-window)
  'stack-graphics-enabled)


(define *graphics-window-width*  400)
(define *graphics-window-height* 600)

(define *graphics-window-wrap-quotient* 0)

(define (initialize-graphics-window)
  (cond (*regsim-stack-graphics?*
	 ;; Always start w/ a fresh window in case we alter dimensions etc.
	 (cond (*graphics-window*
		(graphics-close *graphics-window*)))
	 (set! *graphics-window*
	       (make-window *graphics-window-width* *graphics-window-height* -2 +320))
	 (graphics-operation *graphics-window*
			     'set-window-name
			     "Graphics: Stack Trace")
	 (set! *graphics-window-wrap-quotient* 0)
	 (graphics-set-coordinate-limits *graphics-window* 0 0 *graphics-window-width* 
					                       *graphics-window-height*))))

(define (graphics-window-width-modulo x) 
  ;; Uhm... wrap the bloody stack
  (let ((x-warp-quotient (quotient x *graphics-window-width*)))
    (cond ((> x-warp-quotient *graphics-window-wrap-quotient*) ; wrapped again
	   (clear-graphics)
	   (set! *graphics-window-wrap-quotient* x-warp-quotient))))
  (modulo x *graphics-window-width*))


(define (draw-point x y)		; shameless hack for 3X3 pixels
  (define gwwm graphics-window-width-modulo)
  (define (2+ n) (+ n 2))
  (define *graphics-point-width*  3)
  (define *graphics-point-height* 3)
  (set! x (* x *graphics-point-width*))
  (set! y (* y *graphics-point-height*))
  (graphics-draw-point *graphics-window* (gwwm     x )     y )
  (graphics-draw-point *graphics-window* (gwwm     x ) (1+ y))
  (graphics-draw-point *graphics-window* (gwwm     x ) (2+ y))
  (graphics-draw-point *graphics-window* (gwwm (1+ x)) (2+ y))
  (graphics-draw-point *graphics-window* (gwwm (2+ x)) (2+ y))
  (graphics-draw-point *graphics-window* (gwwm (2+ x)) (1+ y))
  (graphics-draw-point *graphics-window* (gwwm (2+ x))     y )
  (graphics-draw-point *graphics-window* (gwwm (1+ x))     y )
  (graphics-draw-point *graphics-window* (gwwm (1+ x)) (1+ y))
  )



