;;; -*- Mode:Scheme; Base:10 -*- PS9-ECEV.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			   Spring Semester, 1993
;;
;;				 Problem Set 9

;;;; 6.001 Explicit-Control Register-Machine Evaluator

;;; ENVIRONMENT INITIALIZATION...the ENVIRONMENT data abstraction appears in
;;;  the file PS9-SNTX.SCM

;;; We initialize the global environment by snarfing many primitives from the
;;; underlying Scheme system.  This is different from the notes' treatment of
;;; primitives. If you want more primitives in your evaluator, just modify the
;;; list PRIMITIVE-PROCEDURE-NAMES to include their names or just use
;;; EXTEND-PRIMITIVES to gobble primitives from the underlying Scheme system.

(define goosey-primitives		; Cannot tolerate non-primitive args
  '(+ - * / < > = <= >= 1+ -1+))
(define ducky-primitives		; Args needn't be primitive data
  '(car cdr cons append not eq? pair? null?
	clear-graphics enable-stack-graphics disable-stack-graphics))
  
(define (primitive-procedure-names)(append ducky-primitives goosey-primitives))

(define (ducky? p) (not (memq (primitive-id p)
			      (map eval-in-initial-env goosey-primitives))))

(define (setup-environment)  
  (let ((initial-env
	  (extend-environment (primitive-procedure-names)
			      (map (lambda (pname)
					(make-primitive
					  (eval-in-initial-env pname)))
				      (primitive-procedure-names))
			      the-empty-environment)))
    (define (extend-primitives procedure-names)
      (cond ((null? procedure-names) '---done---)
            (else (define-variable! (car procedure-names)
		    (make-primitive
		     (eval-in-initial-env (car procedure-names)))
                    initial-env)
                  (extend-primitives (cdr procedure-names)))))
    (define-variable! 'nil    nil   initial-env)
    (define-variable! 'true   true  initial-env)
    (define-variable! 'false  false initial-env)
    (define-variable! 'extend-primitives
      (make-primitive extend-primitives)
      initial-env)
    initial-env))

(define (eval-in-initial-env form)
  (eval form user-initial-environment))

(define the-global-environment (setup-environment))

;;; From 5.2.1

(define (make-bindings proc args)
  (extend-binding-environment (parameters proc)
                              args
                              (procedure-environment proc)))

(define (extend-binding-environment vars args env)
  (extend-environment vars (reverse args) env))

;;; From 5.3.6

(define (user-print object)
  (cond ((compound-procedure? object)
         (write-line (list 'compound-procedure
			   (parameters object)
			   (procedure-body object)
			   '<procedure-env>)))
        ((compiled-procedure? object)
         (write-line '<compiled-procedure>))
        (else (write-line object))))

;; The EC-EVAL machine with stuff from 5.3.6 for compiler-eceval interface

(define (non-null? x) (not (null? x)))

(define-machine explicit-control-evaluator
  (registers exp env val continue fun argl unev
	     arg0 arg1 arg2 arg3)	; ------------APH------------
  (controller
  (perform (newline))
  (perform (display "========== Entering EC Eval REPL =========="))
read-eval-print-loop
  (perform (initialize-stack))			       ;;;
  (perform (initialize-ops-counter))                   ;;; 
  (perform (newline))
  (perform (display "----------------------------------------"))
  (perform (newline))
  (perform (display "EC-EVAL==> "))
  (assign exp (read))
  (perform (initialize-graphics-window))	       ;;;
  (branch (exit-on? (fetch exp)) ec-eval-exit)
  (assign env the-global-environment)
  (assign continue print-result)
  (goto eval-dispatch)
print-result
  (perform (user-print (fetch val)))
  (goto read-eval-print-loop)

unknown-procedure-type-error
  (assign val '>>>Unknown-procedure-type-error)
  (goto signal-error)
unknown-expression-type-error
  (assign val '>>>Unknown-expression-type-error)
signal-error
  (perform (newline))
  (perform (user-print (fetch val)))		;; Err mesg in VAL
  (perform (user-print (fetch exp)))		;; Irritant in EXP
  (goto read-eval-print-loop)

external-entry
   (perform (initialize-stack))
   (assign env the-global-environment)
   (assign continue print-result)
   (save continue)
   (goto (fetch val))

eval-dispatch
  (branch (self-evaluating?  (fetch exp)) ev-self-eval)
  (branch (quoted?           (fetch exp)) ev-quote)
  (branch (variable?         (fetch exp)) ev-variable)
  (branch (definition?       (fetch exp)) ev-definition)
  (branch (assignment?       (fetch exp)) ev-assignment)
  (branch (lambda?           (fetch exp)) ev-lambda)
  (branch (conditional?      (fetch exp)) ev-cond)
  (branch (no-args?          (fetch exp)) ev-no-args)
  (branch (args-application? (fetch exp)) ev-application)
  (goto unknown-expression-type-error)
ev-self-eval
  (assign val (fetch exp))
  (goto (fetch continue))
ev-quote
  (assign val (text-of-quotation (fetch exp)))
  (goto (fetch continue))
ev-variable
  (assign val (lookup-variable-value (fetch exp) (fetch env)))
  (goto (fetch continue))
ev-lambda
  (assign val (make-procedure (fetch exp) (fetch env)))
  (goto (fetch continue))
ev-no-args
  (assign exp (operator (fetch exp)))
  (save continue)
  (assign continue setup-no-arg-apply)
  (goto eval-dispatch)
setup-no-arg-apply
  (assign fun (fetch val))
  (assign argl '())
  (goto apply-dispatch)

ev-application
  (assign unev (operands (fetch exp)))
  (assign exp (operator (fetch exp)))
  (save continue)
  (save env)
  (save unev)
  (assign continue eval-args)
  (goto eval-dispatch)
eval-args
  (restore unev)
  (restore env)
  (assign fun (fetch val))
  (save fun)
  (assign argl '())
  (goto eval-arg-loop)

eval-arg-loop
  (save argl)
  (assign exp (first-operand (fetch unev)))
  (branch (last-operand? (fetch unev)) eval-last-arg)
  (save env)
  (save unev)
  (assign continue accumulate-arg)
  (goto eval-dispatch)
accumulate-arg
  (restore unev)
  (restore env)
  (restore argl)
  (assign argl (cons (fetch val) (fetch argl)))
  (assign unev (rest-operands (fetch unev)))
  (goto eval-arg-loop)
eval-last-arg
  (assign continue accumulate-last-arg)
  (goto eval-dispatch)
accumulate-last-arg
  (restore argl)
  (assign argl (cons (fetch val) (fetch argl)))
  (restore fun)
  (goto apply-dispatch)

apply-dispatch
  (branch (primitive-procedure? (fetch fun)) primitive-apply)
  (branch ( compound-procedure? (fetch fun))  compound-apply)
  (branch ( compiled-procedure? (fetch fun))  compiled-apply)
  (assign exp (fetch fun))		;; Place irritant in EXP
  (goto unknown-procedure-type-error)
compiled-apply
   (assign val (compiled-procedure-entry (fetch fun)))
   (goto (fetch val))
primitive-apply
  (assign val
          (apply-primitive-procedure (fetch fun)
                                     (fetch argl)))
  (restore continue)
  (goto (fetch continue))
compound-apply
  (assign env (make-bindings (fetch fun) (fetch argl)))
  (assign unev (procedure-body (fetch fun)))
  (goto eval-sequence)
eval-sequence
  (assign exp (first-exp (fetch unev)))
  (branch (last-exp? (fetch unev)) last-exp)
  (save unev)
  (save env)
  (assign continue eval-sequence-continue)
  (goto eval-dispatch)
eval-sequence-continue
  (restore env)
  (restore unev)
  (assign unev (rest-exps (fetch unev)))
  (goto eval-sequence)
last-exp
  (restore continue)
  (goto eval-dispatch)

ev-cond
  (save continue)
  (assign continue evcond-decide)
  (assign unev (clauses (fetch exp)))
evcond-pred
  (branch (no-clauses? (fetch unev)) evcond-return-nil)
  (assign exp (first-clause (fetch unev)))
  (branch (else-clause? (fetch exp)) evcond-else-clause)
  (save env)
  (save unev)
  (assign exp (predicate (fetch exp)))
  (goto eval-dispatch)

evcond-return-nil
  (restore continue)
  (assign val nil)
  (goto (fetch continue))
evcond-decide
  (restore unev)
  (restore env)
  (branch (true? (fetch val)) evcond-true-predicate)
  (assign unev (rest-clauses (fetch unev)))
  (goto evcond-pred)
evcond-true-predicate
  (assign exp (first-clause (fetch unev)))
evcond-else-clause
  (assign unev (actions (fetch exp)))
  (goto eval-sequence)
ev-assignment
  (assign unev (assignment-variable (fetch exp)))
  (save unev)
  (assign exp (assignment-value (fetch exp)))
  (save env)
  (save continue)
  (assign continue ev-assignment-1)
  (goto eval-dispatch)
ev-assignment-1
  (restore continue)
  (restore env)
  (restore unev)
  (perform
   (set-variable-value! (fetch unev) (fetch val) (fetch env)))
  (goto (fetch continue))
ev-definition
  (assign unev (definition-variable (fetch exp)))
  (save unev)
  (assign exp (definition-value (fetch exp)))
  (save env)
  (save continue)
  (assign continue ev-definition-1)
  (goto eval-dispatch)
ev-definition-1
  (restore continue)
  (restore env)
  (restore unev)
  (perform
   (define-variable! (fetch unev) (fetch val) (fetch env)))
  (assign val the-undefined-value)
  (goto (fetch continue))

ec-eval-exit
  (perform (newline))
  (perform (display "********** Exiting EC Eval REPL **********"))
  (assign val (exit (fetch exp)))	;; Leave exit message in VAL
  ))

(define the-undefined-value '*undefined*)

(define (go)
  (start explicit-control-evaluator))


(define (exit exp)
  (if (pair? exp) (car exp) exp))

(define (exit-on? exp)
  (member exp the-many-names-of-exit))

(define the-many-names-of-exit
  '( bye   quit   exit   punt   game-over   fini   toast   i-am-outta-here
    (bye) (quit) (exit) (punt) (game-over) (fini) (toast) (i-am-outta-here)))


;;; From 5.3.6 for compiler interface

(define (make-compiled-procedure entry env)
  (list 'compiled-procedure entry env))

(define (compiled-procedure? proc) (tagged-list? proc 'compiled-procedure))

(define (compiled-procedure-entry c-proc) (cadr  c-proc))
(define (compiled-procedure-env   c-proc) (caddr c-proc))

(define (compile-and-go expression)
  (remote-assign
   explicit-control-evaluator
   'val
   (build-instruction-list explicit-control-evaluator
			   (compile expression)))
  (eval '(goto external-entry)
	explicit-control-evaluator))




