;;; The bottom level typing system

(define (attach-type type contents)
  (if (and (eq? type 'number) (number? contents))
      contents
      (cons type contents)))


(define (type datum)
  (cond ((number? datum) 'number)
        ((pair? datum) (car datum))
        (else (error "Bad typed datum -- TYPE" datum))))


(define (contents datum)
  (cond ((number? datum) datum)
        ((pair? datum) (cdr datum))
        (else (error "Bad typed datum -- CONTENTS" datum))))



;;; The operate mechanism.  Note that we don't deal with coercion here.

(define (operate op obj)
  (let ((proc (get (type obj) op)))
    (if proc				;operator is defined on type
        (proc (contents obj))
        (error "Operator undefined on this type -- OPERATE"
               (list op obj)))))


(define (operate-2 op arg1 arg2)
  (let ((t1 (type arg1)))
    (if (eq? t1 (type arg2))
        (let ((proc (get t1 op)))
          (if proc 
              (proc (contents arg1) (contents arg2))
              (error
               "Operator undefined on this type -- OPERATE-2"
               (list op arg1 arg2))))
        (error "Operands not of same type -- OPERATE-2"
               (list op arg1 arg2)))))


