;;; Matcher code for PS4 (and lecture)

;; Pattern Matching and Simplification


(define (match pattern expression dictionary)
  (cond ((not (good-match? dictionary)) 'failed)
        ((literal? pattern)	
         (if (eqv? pattern expression) dictionary 'failed))
	((arbitrary-variable? pattern)
	 (let ((restriction-result
		(apply-restriction pattern expression)))
	   (if restriction-result
	       (extend-dictionary pattern expression restriction-result dictionary)
	       'failed)))
	((not (pair? expression)) 'failed)
        (else
         (match (cdr pattern)
                (cdr expression)
		(match (car pattern) (car expression) dictionary)))))

(define (good-match? d)
  (not (eq? d 'failed)))

;; Dictionaries
;; A dictionary will hold a name, the expression bound to, and a result
;; computed from the match

(define (make-empty-dictionary) '())

(define (extend-dictionary pat data result dictionary)
  (let ((vname (pattern-variable-name pat)))
    (let ((v (assq vname dictionary)))
      (cond ((not v) (cons (list vname data result) dictionary))
            ((eqv? (cadr v) dat) dictionary)
            (else 'failed)))))

(define (lookup var dictionary)
  (let ((v (assq var dictionary)))
    (if v
        (cadr v)
	(error "variable not in dictionary" var))))

(define (restriction-result var dictionary)
  (let ((v (assq var dictionary)))
    (if v
        (caddr v)
	(error "variable not in dictionary" var))))


;; Expressions

(define (compound? exp) (pair?   exp))
(define (constant? exp) (number? exp))

;; Rules

(define (pattern  rule) (car  rule))
(define (skeleton rule) (cadr rule))

;; Patterns

(define (literal? pattern) (not (pair? pattern)))

(define (arbitrary-variable? pattern)
  (and (pair? pattern)
       (eq? (car pattern) '?)))

(define (pattern-variable-name pattern) (cadr pattern))

(define (apply-restriction pattern data)
  (let ((tail (cddr pattern)))
    (if (null? tail)
	true
	(let ((restriction-proc (evaluate-expression (car tail))))
	  (restriction-proc data)))))

(define global-environment (the-environment))
;;(define global-environment (->environment '(student)))

(define (evaluate-expression exp)
  (eval exp global-environment))

