;;;

(define the-empty-memory '())

(define (recall key memories)
  (let ((entry (assoc key memories)))
    (if entry
	(cdr entry)
	false)))

(define (memorize-list key values memories)
  (if (null? values)
      memories
      (memorize-list key
		     (cdr values)
		     (make-memory key
				  (car values)
				  memories))))

(define (make-memory key value memories)
  (define (scan-loop mem)
    (cond ((null? mem)
	   (list (list key value)))
	  ((equal? key (caar mem))
	   (cons (cons key
		       (cons value
			     (cdar mem)))
		 (cdr mem)))
	  (else
	   (cons (car mem)
		 (scan-loop (cdr mem))))))
  (scan-loop memories))

(define prefix caadr)
(define suffix cdadr)
(define match-result caddr)

;;; Asking for a recipe

(define (find-recipe input memories)
  (let ((split-recipe-request
	 (starts-with-one-of input
			     recipe-query-prefixes)))
    (if split-recipe-request
	(make-response (spit-out-recipe (suffix split-recipe-request)
					memories)
		       memories)
	false)))

(define recipe-query-prefixes
  (list (make-rule '(how do you make) '())
	(make-rule '(what is the recipe for) '())))

(define (spit-out-recipe remaining-input memories)
  (let ((split-food-item-request
	 (starts-with-one-of remaining-input 
			     (recall 'recipes memories))))
    (if split-food-item-request
	(spit-out-scaled-recipe (prefix split-food-item-request)
				(suffix split-food-item-request)
				(match-result split-food-item-request))
	(do-not-know-recipe remaining-input))))

(define (spit-out-scaled-recipe food-type remaining-input recipe)
  (let ((servings
	  (scan-for (lambda (words)
		      (number? (car words)))
		    remaining-input)))
    (append '(to make)
	    food-type
	    (if servings
		(scale-recipe recipe (car servings))
		recipe))))

(define (scale-recipe recipe servings)
  (if (null? recipe)
      '()
       (let ((first (car recipe)))
	 (cons (if (number? first)
		   (* first servings)
		   first)
	       (scale-recipe (cdr recipe) servings)))))

(define (do-not-know-recipe remaining-input)
  (append (pick-random unknown-recipe-introductions)
	  remaining-input))

(define unknown-recipe-introductions
  '((i do not know how to make)
    (i am not familiar with)
    (we do not have the technology to make)
    (you can ask our dietitian how to make)
    (ask george how to make)
    (your mother can tell you how to make)))

(define student-fodder
  (list (make-rule '(spaghetti with meat sauce)
		   '(mix 30 strands spaghetti with 1 gallon water
			 and boil for 2 minutes adding 1 ounce sauce))
	(make-rule '(veal parmesan)
		   '(grill 1 veal pattie with 1 pad cheese))
	(make-rule '(bubble gum pizza)
		   '(find 1 wad gum from under a chair
			  then boil and stretch to cover 1 ordinary pizza))))

;;;

(define (scan-for predicate remaining-input)
  (if (null? remaining-input)
      false
      (if (predicate remaining-input)
	  remaining-input
	  (scan-for predicate (cdr remaining-input)))))

(define (starts-with-one-of input rules)
  (define (inner remaining-rules)
    (if (null? remaining-rules)
	false
	(let ((match (matches? input
			       (pattern (car remaining-rules)))))
	  (if match
	      (split-sentence (car match)
			      (cdr match)
			      (substitute (car remaining-rules)))
	      (inner (cdr remaining-rules))))))
  (inner rules))

(define (matches? input pattern)
  (define (inner remaining-input remaining-pattern)
    (cond ((null? remaining-pattern)
           (cons pattern remaining-input))
	  ((null? remaining-input)
	   false)
          ((eq? (car remaining-input)
		(car remaining-pattern))
	   (inner (cdr remaining-input)
		  (cdr remaining-pattern)))
	  (else false)))
  (inner input pattern))

(define (new-construct-reply input memories)
  (cond ((process-gripe input memories))   ; FALSE unless gripe
        ((find-recipe input memories))
	((with-odds 1 3)                   ; not FALSE one in three times
	 (make-response
	  (cond ((reflect-old-gripe memories))
		(else
		 (append (pick-random reflect-beginnings)
			 (reflect-input input normal-reflections))))
	  memories))
	(else
	  (make-response (pick-random general-advice)
			 memories))))