;;; code for city navigation problem set

;;; constructors for data abstractions

(define make-block
  (lambda (block-name block-end-points)
    (list block-name block-end-points)))

(define make-street
  (lambda (street-name street-end-points)
    (list street-name street-end-points)))

(define make-end-points
   (lambda (start end) (list start end)))

(define make-point
   (lambda (x y) (cons x y)))

(define make-map list)

(define make-trip list)

;;; first pass at finding correspondences

(define all-correspondences
   (lambda (trip map)
      (if (empty-trip? trip)       ; note use of abstraction to test
          (list the-empty-correspondence)   ;Note1
          (let ((street-to-match (first trip))   ; get first street
                (streets (rest trip)))           ; and rest of streets
            (define matcher                      ; create procedure to match
              (lambda (blocks)                   ; blocks recursively
                (if (empty-map? blocks)
                    the-empty-list               ;Note2
                    (append (extend-correspondences
                              (pair-up street-to-match (first-block blocks))
                              (all-correspondences streets
                                                   (remove-elt (first-block blocks) map)))
                            (matcher (rest-blocks blocks))))))
            (matcher map)))))

(define extend-correspondences
   (lambda (pair correspondences)
     (define extend-all                    ; recursively extend all the correspondences
        (lambda (corresps)                 ;	
           (if (null? corresps)            ; since corresps is a list, use null?
               the-empty-list
               (cons (augment-correspondence pair (car corresps))  ; add new correpondences
                     (extend-all (cdr corresps))))))               ; to extension of others
     (extend-all correspondences)))

;;; My data abstraction implementations are below this line.

(define the-empty-list '())     ;Ben B. says this is good magic.
(define first car)
(define rest cdr)
(define first-block car)
(define rest-blocks cdr)

(define empty-map? null?)
(define empty-trip? null?)

(define the-empty-correspondence the-empty-list)
(define augment-correspondence cons)

(define pair-up list)
(define pair-street car)
(define pair-block cadr)



;; some utilities

(define remove-elt
  (lambda (elt lst)
    (cond ((null? lst) '())
          ((eq? elt (car lst))
           (remove-elt elt (cdr lst)))
          (else (cons (car lst) (remove-elt elt (cdr lst)))))))

(define print-correspondences 
  (lambda (corresps)
     (if (null? corresps)
         nil
         (sequence
           (newline)
           (princ "Next correspondence -- type a space")
           (readch)
           (print-correspondence (car corresps))
           (princ-correpsondences (cdr corresps))))))

(define print-correspondence
  (lambda (corr)
    (cond ((null? corr) nil)
          (else (newline)
                (princ "Street = ")
                (princ (street-name (pair-street (car corr))))
                (princ " Block = ")
                (princ (block-name (pair-block (car corr))))
                (print-correspondence (cdr corr))))))

;;; some trial data

(define block-1 (make-block 1 (make-end-points (make-point 0 0) 
                                               (make-point 1 0))))
(define block-2 (make-block 1 (make-end-points (make-point 1 0) 
                                               (make-point 3 0))))
(define block-3 (make-block 1 (make-end-points (make-point 3 0) 
                                               (make-point 4 0))))

(define block-4 (make-block 2 (make-end-points (make-point 0 1) 
                                               (make-point 1 1))))
(define block-5 (make-block 2 (make-end-points (make-point 1 1) 
                                               (make-point 2 1))))

(define block-6 (make-block 3 (make-end-points (make-point 0 2) 
                                               (make-point 1 2))))
(define block-7 (make-block 3 (make-end-points (make-point 1 2)
                                               (make-point 2 2))))
(define block-8 (make-block 3 (make-end-points (make-point 2 2) 
                                               (make-point 3 2))))
(define block-9 (make-block 3 (make-end-points (make-point 3 2) 
                                               (make-point 4 2))))

(define block-10 (make-block 4 (make-end-points (make-point 0 3) 
                                                (make-point 1 3))))
(define block-11 (make-block 4 (make-end-points (make-point 1 3) 
                                                (make-point 2 3))))
(define block-12 (make-block 4 (make-end-points (make-point 2 3) 
                                                (make-point 3 3))))
(define block-13 (make-block 4 (make-end-points (make-point 3 3) 
                                                (make-point 4 3))))

(define block-14 (make-block 5 (make-end-points (make-point 0 0) 
                                                (make-point 0 1))))
(define block-15 (make-block 5 (make-end-points (make-point 0 1) 
                                                (make-point 0 2))))
(define block-16 (make-block 5 (make-end-points (make-point 0 2) 
                                                (make-point 0 3))))

(define block-17 (make-block 6 (make-end-points (make-point 1 0) 
                                                (make-point 1 1))))
(define block-18 (make-block 6 (make-end-points (make-point 1 2) 
                                                (make-point 1 3))))

(define block-19 (make-block 7 (make-end-points (make-point 2 1) 
                                                (make-point 2 2))))
(define block-20 (make-block 7 (make-end-points (make-point 2 2) 
                                                (make-point 2 3))))

(define block-21 (make-block 8 (make-end-points (make-point 3 2) 
                                                (make-point 3 3))))

(define block-22 (make-block 9 (make-end-points (make-point 4 0) 
                                                (make-point 4 2))))
(define block-23 (make-block 9 (make-end-points (make-point 4 2) 
                                                (make-point 4 3))))

(define block-24 (make-block 10 (make-end-points (make-point 1 2) 
                                                 (make-point 2 1))))
(define block-25 (make-block 10 (make-end-points (make-point 2 12) 
                                                 (make-point 3 0))))


(define block-26 (make-block 11 (make-end-points (make-point 2 1) 
                                                 (make-point 3 2))))

(define trial-map-1
    (make-map block-1 block-2 block-3 block-4 block-5 block-6
              block-7 block-8 block-9 block-10 block-11 block-12
              block-13 block-14 block-15 block-16 block-17 block-18
              block-19 block-20 block-21 block-22 block-23 block-24
              block-25 block-26))

(define trial-trip-0
    (make-trip (make-street 3 (make-end-points (make-point 0 0)
                                               (make-point 0 1)))))

(define trial-trip-1 
    (make-trip (make-street 0 (make-end-points (make-point 0 0)
                                               (make-point 0 1)))))

(define trial-trip-2
    (make-trip (make-street 0 (make-end-points (make-point 0 0)
                                               (make-point 0 1)))
               (make-street 3 (make-end-points (make-point 0 0)
                                               (make-point 1 1)))))

(define trial-trip-2
    (make-trip (make-street 0 (make-end-points (make-point 0 0)
                                               (make-point 0 1)))
               (make-street 3 (make-end-points (make-point 0 0)
                                               (make-point 1 1)))
               (make-street 0 (make-end-points (make-point 1 1)
                                               (make-point 2 0)))))