
% OL(P): Object Layer for Prolog -- utilities
% Version 1.1 for SICStus Prolog and QUINTUS Prolog
% (C) 1993 Markus P.J. Fromherz.  All Rights Reserved.
% (C) 1993 Xerox Corporation.     All Rights Reserved.


% lists

ol_list_of_el([], _, _).
ol_list_of_el([X|Xs], E, Cond) :-
   \+ \+ (X=E, Cond),
   ol_list_of_el(Xs, E, Cond).

ol_member(X, [X|_]).
ol_member(X, [_|Xs]) :-
   ol_member(X, Xs).

ol_remove(X, [X|Xs], Xs).
ol_remove(X, [Y|Xs], [Y|Ys]) :-
  ol_remove(X, Xs, Ys).

ol_remove_all(_, [], []).
ol_remove_all(Ds, [X|Xs], Ys) :-
   ol_member(X, Ds),
   !,
   ol_remove_all(Ds, Xs, Ys).
ol_remove_all(Ds, [X|Xs], [X|Ys]) :-
   ol_remove_all(Ds, Xs, Ys).


% conjunctions

ol_conj_of_el(C, C, Cond) :-
   Cond.
ol_conj_of_el(C, E, Cond) :-
   nonvar(C), C = (A,B),
   \+ \+ ol_conj_of_el(A, E, Cond),
   \+ \+ ol_conj_of_el(B, E, Cond).

ol_list_conj([G], G) :-
   !.
ol_list_conj([G|Gs], (G,H)) :-
   ol_list_conj(Gs, H).

ol_member_conj(X, X) :-
   \+ ( X = (_,_) ).
ol_member_conj(X, (X,_)).
ol_member_conj(X, (_,Xs)) :-
   ol_member_conj(X, Xs).


% i/o

ol_portray_facts(OutStream, Fact) :-
   Fact,
   portray_clause(OutStream, Fact),
   fail.
ol_portray_facts(_, _).

ol_append_suffix(Name, SuffixString, File) :-
   name(Name, NameString),
   ol_append(NameString, SuffixString, FileString),
   name(File, FileString).

ol_append_extension(NameString, ExtensionList, File) :-
   ol_concatenate_to_string(ExtensionList, ExtensionString),
   ol_append(NameString, [46|ExtensionString], FileString),   % .
   name(File, FileString),
   !.

ol_concatenate_to_string([], "").
ol_concatenate_to_string([Atom|Atoms], AllStrings) :-
   ol_concatenate_to_string(Atoms, Strings),
   name(Atom, String),
   ol_append(String, Strings, AllStrings).

ol_base_language(FileString, FRString, BL) :-
   ol_append(FRString, [46|BLString], FileString), \+ ol_member(46, BLString),  % .
   !,
   name(BL, BLString).

% goals

ol_syntax(Condition, TrueAction, FalseAction) :-
   Condition -> TrueAction; FalseAction.

ol_once(Goal) :-      % often \+ \+ is used instead of ol_once/1
   Goal,
   !.
