object difference_list is_a list.

   % This object contains methods for difference lists.
   % The list's format is List-Tail.
   % Note that append/3 and append_one/3 expected Tail to be a variable.

   :- override empty/1,        % empty(Xs-Xs)
               equal/2,        % equal([1,2|Xs]-Xs, [1,2|Ys]-Ys])
               member/2,       % member(X, [1,2|Xs]-Xs), (X=1;X=2)
               append/3,       % append([1,2|Xs]-Xs, [3|Ys]-Ys, L),
                               % L=[1,2,3|Ys]-Ys
               reverse/2,      % reverse([1,2|Xs]-Xs, L), L=[2,1|Xs]-Xs
               sublist/2,      % sublist([a,b,c|X]-X, L),
                               % (L=[a|Y]-Y;L=[a,b|Y]-Y;...;L=[b|Y]-Y;...)
               included/3,     % included(b, [a,b|X]-X, L), L=[b,a,b|X]-X
               excluded/3,     % excluded(b, [a,b|X]-X, L), L=[a|Y]-Y
               difference/3,   % difference([a,b|X]-X, [b,c|Y]-Y, L), L=[a|Z]-Z
               intersection/3, % intersection([a,b|X]-X, [b,c|Y]-Y, L),
                               % L=[b|Z]-Z
               cardinality/2.  % cardinality([a,b,c|Xs]-Xs, C), C=3
   :- publish  new_dlist/1,    % new_dlist(L), L=Xs-Xs
               append_one/3.   % append_one([1,2|Xs]-Xs, 3, L), L=[1,2,3|Ys]-Ys

   new_dlist(Xs-Xs).

   empty(Xs-TXs) :-
      Xs == TXs.

   equal(Xs-TXs, Xs-TXs).

   member(X, Xs-TXs) :-
      Xs \== TXs, Xs = [X|_].
   member(X, Xs-TXs) :-
      Xs \== TXs, Xs = [_|Xs1],
      this::member(X, Xs1-TXs).

   append(Xs-Ys, Ys-Zs, Xs-Zs).

   append_one(Xs-[X|Ys], X, Xs-Ys).

   reverse(Xs-TXs, Ys-TXs) :-
      this::reverse(Xs-TXs, TXs, Ys).

   reverse(Xs-TXs, Ys, Ys) :-
      Xs == TXs.
   reverse(Xs-TXs, Acc, Ys) :-
      Xs \== TXs, Xs = [X|Xs1],
      this::reverse(Xs1-TXs, [X|Acc], Ys).

   sublist(Xs-TXs, Ys-Ys) :-
      Xs == TXs.
   sublist(Xs-TXs, [X|Ys]-TYs) :-
      Xs \== TXs, Xs = [X|Xs1],
      this::prefix(Xs1-TXs, Ys-TYs).
   sublist(Xs-TXs, Ys) :-
      Xs \== TXs, Xs = [_|Xs1],
      ::sublist(Xs1-TXs, Ys).

   prefix(_, Ys-Ys).
   prefix(Xs-TXs, [X|Ys]-TYs) :-
      Xs \== TXs, Xs = [X|Xs1],
      this::prefix(Xs1-TXs, Ys-TYs).

   included(X, Xs-TXs, [X|Xs]-TXs).

   excluded(X, Xs-TXs, Ys-TXs) :-
      Xs \== TXs, Xs = [X|Ys].
   excluded(X, Xs-TXs, [Y|Ys]-TYs) :-
      Xs \== TXs, Xs = [Y|Xs1],
      this::excluded(X, Xs1-TXs, Ys-TYs).

   difference(Xs-TXs, _, Zs-Zs) :-
      Xs == TXs.
   difference(Xs-TXs, Ys, Zs-TZs) :-
      Xs \== TXs, Xs = [X|Xs1],
      ::member(X, Ys),
      ::difference(Xs1-TXs, Ys, Zs-TZs).
   difference(Xs-TXs, Ys, [X|Zs]-TZs) :-
      Xs \== TXs, Xs = [X|Xs1],
      \+ ::member(X, Ys),
      ::difference(Xs1-TXs, Ys, Zs-TZs).

   intersection(Xs-TXs, _, Zs-Zs) :-
      Xs == TXs.
   intersection(Xs-TXs, Ys, [X|Zs]-TZs) :-
      Xs \== TXs, Xs = [X|Xs1],
      ::excluded(X, Ys, Ys1),
      ::intersection(Xs1-TXs, Ys1, Zs-TZs).
   intersection(Xs-TXs, Ys, Zs) :-
      Xs \== TXs, Xs = [X|Xs1],
      \+ ::excluded(X, Ys, _),
      ::intersection(Xs1-TXs, Ys, Zs).

   cardinality(Xs, L) :-
      this::cardinality(Xs, 0, L).

   cardinality(Xs-TXs, L, L) :-
      Xs == TXs.
   cardinality(Xs-TXs, Acc, L) :-
      Xs \== TXs, Xs = [_|Xs1],
      Acc1 is Acc+1,
      this::cardinality(Xs1-TXs, Acc1, L).

end_object difference_list.

