%
% XWIP version of David Rosenthal's "X Hello World" Program
%

helloWorld :-

	Text = 'Hello, World',
FontName = '-bitstream-charter-medium-r-normal--33-240-100-100-p-183-iso8859-1',

	xOpenConnection([], Connection),

	xOpenFont(Connection, FontName, Font),
	xLoadFont(Connection, Font, LoadedFont),
	xTextExtents(LoadedFont, Text, _, _, Width, Ascent, Descent),

	xQueryConnection(Connection, [xDefaultScreen(DefaultScreen)]),
	xQueryScreen(DefaultScreen,
		     [xRootWindow(RootWindow), 
		      xWidth(ScreenWidth), xHeight(ScreenHeight),
		      xDefaultColormap(DefaultColormap),
		      xWhitePixel(WhitePixel), xBlackPixel(BlackPixel)]),
	
	FontHeight is Ascent + Descent,
	BorderWidth is 1,
	WindowHeight is FontHeight + (2 * BorderWidth),
	WindowWidth is Width + (2 * BorderWidth),
	WindowX is (ScreenWidth - WindowWidth) // 2,
	WindowY is (ScreenHeight - WindowHeight) // 2,

	xCreateWindow(Connection, RootWindow,
		      WindowX, WindowY, WindowWidth, WindowHeight,
	              BorderWidth, xCopyFromParent,
		      xInputOutput, xCopyFromParent,
		      [xBackPixel(BlackPixel), xBorderPixel(WhitePixel),
                       xBitGravity(xCenter),
		       xEventMask([xExposure]),
                       xColormap(DefaultColormap)],
                      Window),
		      
	WMHints = [xInput(xFalse), xInitialState(xNormal)],
	NormalHints = [xProgramX(WindowX),
		       xProgramY(WindowY),
		       xProgramWidth(WindowWidth),
		       xProgramHeight(WindowHeight)],
	xSetStandardProperties(Connection, Window, Text, Text,
	                       WMHints, helloWorld, NormalHints),

	xCreateGC(Connection, Window, 
		  [xForeground(WhitePixel), xBackground(BlackPixel),
		   xFont(Font)],
		  GC),

	xMapWindow(Connection, Window),

	repeat,
	xNextEvent(Connection, xTrue, Event),
	handleEvent(Event, Connection, Window, GC,
		    Text, Width, Ascent, Descent),
	fail.
	
handleEvent(Event, Connection, Window, GC, 
	    Text, Width, Ascent, Descent) :- 
	arg(1, Event, xExpose), arg(10, Event, 0), !,
	filterQueue(Connection, xExpose),

	xQueryWindow(Connection, Window,
		     [xWidth(WindowWidth), xHeight(WindowHeight)]),
	X is (WindowWidth - Width) // 2,
	Y is (WindowHeight + Ascent - Descent) // 2,
		
	xClearArea(Connection, Window, 0, 0, 0, 0, xFalse),
	xDrawText(Connection, Window, GC, X, Y, [Text]).

handleEvent(_, _, _, _, _, _, _, _).

filterQueue(Connection, Type) :-
	xGetEvent(Connection, xAny, [], Type, xTrue, xFalse, _) -> 
	filterQueue(Connection, Type) ; true.

%
% eof
%
